/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.wtp.internal.Messages;
import org.eclipse.m2e.wtp.internal.StringUtils;
import org.eclipse.m2e.wtp.internal.preferences.MavenWtpPreferencesImpl;
import org.eclipse.m2e.wtp.preferences.ConfiguratorEnabler;
import org.eclipse.m2e.wtp.preferences.IMavenWtpPreferences;
import org.eclipse.m2e.wtp.preferences.IMavenWtpPreferencesManager;
import org.osgi.service.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenWtpPreferencesManagerImpl
implements IMavenWtpPreferencesManager {
    private static final String ATTR_ENABLER_ID = "id";
    private static final String ATTR_CONFIGURATOR_IDS = "configuratorIds";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_DESCRIPTION = "description";
    private static final Logger LOG = LoggerFactory.getLogger(MavenWtpPreferencesManagerImpl.class);
    private static final String CONFIGURATOR_ENABLER_EXTENSION_POINT = "org.eclipse.m2e.wtp.javaeeConfiguratorEnabler";
    private List<ConfiguratorEnabler> enablers;

    @Override
    public IMavenWtpPreferences getPreferences(IProject project) {
        if (project == null) {
            return this.loadWorkspacePreferences();
        }
        IEclipsePreferences eclipsePrefs = MavenWtpPreferencesManagerImpl.getEclipsePreferences(project);
        if (eclipsePrefs.getBoolean("org.eclipse.m2e.wtp.enabledProjectSpecificPrefs", false)) {
            return this.convertPreferences(eclipsePrefs);
        }
        return this.loadWorkspacePreferences();
    }

    @Override
    public IMavenWtpPreferences createNewPreferences() {
        return new MavenWtpPreferencesImpl();
    }

    @Override
    public IMavenWtpPreferences getWorkspacePreferences() {
        return this.loadWorkspacePreferences();
    }

    @Override
    public void savePreferences(IMavenWtpPreferences preferences, IProject project) {
        IEclipsePreferences eclipsePrefs;
        if (preferences == null) {
            return;
        }
        if (project != null) {
            eclipsePrefs = MavenWtpPreferencesManagerImpl.getEclipsePreferences(project);
            if (preferences.isEnabledProjectSpecificSettings()) {
                this.transformPreferences(preferences, eclipsePrefs);
            } else {
                this.removeSpecificSettings(eclipsePrefs);
            }
            eclipsePrefs.putBoolean("org.eclipse.m2e.wtp.enabledProjectSpecificPrefs", preferences.isEnabledProjectSpecificSettings());
        } else {
            eclipsePrefs = MavenWtpPreferencesManagerImpl.getEclipsePreferences();
            this.transformPreferences(preferences, eclipsePrefs);
        }
        try {
            eclipsePrefs.flush();
        }
        catch (BackingStoreException e) {
            LOG.error(Messages.MavenWtpPreferencesManagerImpl_0, (Throwable)e);
        }
    }

    private void removeSpecificSettings(IEclipsePreferences eclipsePrefs) {
        eclipsePrefs.remove("org.eclipse.m2e.wtp.ear.applicationXmlInBuilDir");
        eclipsePrefs.remove("org.eclipse.m2e.wtp.war.archiverFilesInBuilDir");
    }

    private IMavenWtpPreferences loadWorkspacePreferences() {
        return this.convertPreferences(MavenWtpPreferencesManagerImpl.getEclipsePreferences());
    }

    private void transformPreferences(IMavenWtpPreferences preferences, IEclipsePreferences eclipsePrefs) {
        eclipsePrefs.putBoolean("org.eclipse.m2e.wtp.ear.applicationXmlInBuilDir", preferences.isApplicationXmGeneratedInBuildDirectory());
        eclipsePrefs.putBoolean("org.eclipse.m2e.wtp.war.archiverFilesInBuilDir", preferences.isWebMavenArchiverUsesBuildDirectory());
        eclipsePrefs.putBoolean("org.eclipse.m2e.wtp.enableM2eWtp", preferences.isEnabled());
    }

    private IMavenWtpPreferences convertPreferences(IEclipsePreferences eclipsePrefs) {
        IMavenWtpPreferences preferences = this.createNewPreferences();
        preferences.setEnabledProjectSpecificSettings(eclipsePrefs.getBoolean("org.eclipse.m2e.wtp.enabledProjectSpecificPrefs", false));
        preferences.setApplicationXmGeneratedInBuildDirectory(eclipsePrefs.getBoolean("org.eclipse.m2e.wtp.ear.applicationXmlInBuilDir", true));
        preferences.setWebMavenArchiverUsesBuildDirectory(eclipsePrefs.getBoolean("org.eclipse.m2e.wtp.war.archiverFilesInBuilDir", true));
        preferences.setEnabled(eclipsePrefs.getBoolean("org.eclipse.m2e.wtp.enableM2eWtp", true));
        return preferences;
    }

    private static IEclipsePreferences getEclipsePreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.m2e.wtp");
    }

    private static IEclipsePreferences getEclipsePreferences(IProject project) {
        return new ProjectScope(project).getNode("org.eclipse.m2e.wtp");
    }

    @Override
    public ConfiguratorEnabler[] getConfiguratorEnablers() {
        if (this.enablers == null) {
            this.enablers = MavenWtpPreferencesManagerImpl.loadConfiguratorEnablers();
        }
        ConfiguratorEnabler[] enablersArray = new ConfiguratorEnabler[this.enablers.size()];
        this.enablers.toArray(enablersArray);
        return enablersArray;
    }

    private static List<ConfiguratorEnabler> loadConfiguratorEnablers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] enablerConfigs = registry.getConfigurationElementsFor(CONFIGURATOR_ENABLER_EXTENSION_POINT);
        if (enablerConfigs == null) {
            return Collections.emptyList();
        }
        ArrayList<ConfiguratorEnabler> enablers = new ArrayList<ConfiguratorEnabler>();
        IConfigurationElement[] iConfigurationElementArray = enablerConfigs;
        int n = enablerConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String enablerId = config.getAttribute(ATTR_ENABLER_ID);
            String[] configuratorIds = MavenWtpPreferencesManagerImpl.split(config.getAttribute(ATTR_CONFIGURATOR_IDS));
            String label = config.getAttribute(ATTR_LABEL);
            String description = config.getAttribute(ATTR_DESCRIPTION);
            enablers.add(new ConfiguratorEnabler(enablerId, label, configuratorIds, description));
            ++n2;
        }
        return enablers;
    }

    private static String[] split(String str) {
        return StringUtils.tokenizeToStringArray(str, ",");
    }

    @Override
    public boolean isEnabled(String configuratorId) {
        ConfiguratorEnabler[] configuratorEnablerArray = this.getConfiguratorEnablers();
        int n = configuratorEnablerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfiguratorEnabler enabler = configuratorEnablerArray[n2];
            if (enabler.appliesTo(configuratorId)) {
                return enabler.isEnabled();
            }
            ++n2;
        }
        return true;
    }
}

