/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.StringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.BaseConvertAnnotation;

public abstract class EclipseLinkSourceBaseConvertAnnotation
extends SourceAnnotation
implements BaseConvertAnnotation {
    private final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter = this.buildValueDeclarationAdapter();
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;
    private TextRange valueTextRange;

    protected EclipseLinkSourceBaseConvertAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        super((JavaResourceModel)parent, element, daa);
        this.valueAdapter = new AnnotatedElementAnnotationElementAdapter(element, this.valueDeclarationAdapter);
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.value = this.buildValue(astAnnotation);
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncValue(this.buildValue(astAnnotation));
        this.valueTextRange = this.buildValueTextRange(astAnnotation);
    }

    public boolean isUnset() {
        return super.isUnset() && this.value == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (ObjectTools.notEquals((Object)this.value, (Object)value)) {
            this.value = value;
            this.valueAdapter.setValue((Object)value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(Annotation astAnnotation) {
        return (String)this.valueAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getValueTextRange() {
        return this.valueTextRange;
    }

    private TextRange buildValueTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astAnnotation);
    }

    @Override
    public boolean valueTouches(int pos) {
        return this.textRangeTouches(this.valueTextRange, pos);
    }

    private DeclarationAnnotationElementAdapter<String> buildValueDeclarationAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter(this.daa, this.getValueElementName(), StringExpressionConverter.instance());
    }

    protected abstract String getValueElementName();
}

