/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.jaxb.core.context.XmlElement;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlElementMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.AbstractJavaXmlNamedNodeMapping;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlElement;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlElementWrapper;
import org.eclipse.jpt.jaxb.core.internal.context.java.GenericJavaXmlIDREF;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementWrapperAnnotation;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdFeature;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJavaXmlElementMapping
extends AbstractJavaXmlNamedNodeMapping<XmlElementAnnotation>
implements JavaXmlElementMapping {
    protected final XmlElement xmlElement = this.buildXmlElement();
    protected XmlElementWrapper xmlElementWrapper;

    public GenericJavaXmlElementMapping(JavaPersistentAttribute parent) {
        super(parent);
        this.initializeXmlElementWrapper();
    }

    @Override
    public String getKey() {
        return "xml-element";
    }

    @Override
    protected String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlElement";
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.xmlElement.synchronizeWithResourceModel();
        this.syncXmlElementWrapper();
    }

    @Override
    public void update() {
        super.update();
        this.xmlElement.update();
        this.updateXmlElementWrapper();
    }

    @Override
    public XmlElement getXmlElement() {
        return this.xmlElement;
    }

    protected XmlElement buildXmlElement() {
        return new GenericJavaXmlElement(this, new XmlElementContext());
    }

    @Override
    public XmlElementWrapper getXmlElementWrapper() {
        return this.xmlElementWrapper;
    }

    protected XmlElementWrapper buildXmlElementWrapper() {
        return new GenericJavaXmlElementWrapper(this, new GenericJavaXmlElementWrapper.SimpleContext(this.getXmlElementWrapperAnnotation()));
    }

    @Override
    public XmlElementWrapper addXmlElementWrapper() {
        if (this.xmlElementWrapper != null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().addAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        XmlElementWrapper xmlElementWrapper = this.buildXmlElementWrapper();
        this.setXmlElementWrapper_(xmlElementWrapper);
        return xmlElementWrapper;
    }

    @Override
    public void removeXmlElementWrapper() {
        if (this.xmlElementWrapper == null) {
            throw new IllegalStateException();
        }
        this.getJavaResourceAttribute().removeAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
        this.setXmlElementWrapper_(null);
    }

    protected void initializeXmlElementWrapper() {
        if (this.getXmlElementWrapperAnnotation() != null) {
            this.xmlElementWrapper = this.buildXmlElementWrapper();
        }
    }

    protected XmlElementWrapperAnnotation getXmlElementWrapperAnnotation() {
        return (XmlElementWrapperAnnotation)this.getJavaResourceAttribute().getAnnotation("javax.xml.bind.annotation.XmlElementWrapper");
    }

    protected void syncXmlElementWrapper() {
        if (this.getXmlElementWrapperAnnotation() != null) {
            if (this.getXmlElementWrapper() != null) {
                this.getXmlElementWrapper().synchronizeWithResourceModel();
            } else {
                this.setXmlElementWrapper_(this.buildXmlElementWrapper());
            }
        } else {
            this.setXmlElementWrapper_(null);
        }
    }

    protected void updateXmlElementWrapper() {
        if (this.getXmlElementWrapper() != null) {
            this.getXmlElementWrapper().update();
        }
    }

    protected void setXmlElementWrapper_(XmlElementWrapper xmlElementWrapper) {
        XmlElementWrapper oldXmlElementWrapper = this.xmlElementWrapper;
        this.xmlElementWrapper = xmlElementWrapper;
        this.firePropertyChanged("xmlElementWrapper", oldXmlElementWrapper, xmlElementWrapper);
    }

    @Override
    protected boolean calculateDefaultXmlList() {
        return false;
    }

    @Override
    protected GenericJavaXmlIDREF.Context buildXmlIDREFContext() {
        return new XmlIDREFContext();
    }

    @Override
    public Iterable<String> getReferencedXmlTypeNames() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.getReferencedXmlTypeNames(), this.xmlElement.getReferencedXmlTypeNames()});
    }

    @Override
    public boolean isParticleMapping() {
        return true;
    }

    @Override
    public XsdFeature getXsdFeature() {
        XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
        if (xsdType != null) {
            XmlElementWrapper elementWrapper = this.xmlElementWrapper;
            if (elementWrapper == null) {
                return xsdType.getElement(this.xmlElement.getQName().getNamespace(), this.xmlElement.getQName().getName());
            }
            XsdElementDeclaration xsdWrapperElement = elementWrapper.getXsdElementDeclaration();
            if (xsdWrapperElement != null) {
                return xsdWrapperElement.getElement(this.xmlElement.getQName().getNamespace(), this.xmlElement.getQName().getName());
            }
        }
        return null;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        result = this.xmlElement.getCompletionProposals(pos);
        if (!IterableTools.isEmpty(result)) {
            return result;
        }
        if (this.xmlElementWrapper != null && !IterableTools.isEmpty(result = this.xmlElementWrapper.getCompletionProposals(pos))) {
            return result;
        }
        return EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.xmlElement.validate(messages, reporter);
        if (this.xmlElementWrapper != null) {
            this.xmlElementWrapper.validate(messages, reporter);
        }
    }

    protected class XmlElementContext
    implements GenericJavaXmlElement.Context {
        protected XmlElementContext() {
        }

        @Override
        public XmlElementAnnotation getAnnotation(boolean createIfNull) {
            return createIfNull ? (XmlElementAnnotation)GenericJavaXmlElementMapping.this.getOrCreateAnnotation() : (XmlElementAnnotation)GenericJavaXmlElementMapping.this.getAnnotation();
        }

        @Override
        public JavaAttributeMapping getAttributeMapping() {
            return GenericJavaXmlElementMapping.this;
        }

        @Override
        public String getDefaultType() {
            return GenericJavaXmlElementMapping.this.getPersistentAttribute().getJavaResourceAttributeBaseTypeName();
        }

        @Override
        public XmlElementWrapper getElementWrapper() {
            return GenericJavaXmlElementMapping.this.getXmlElementWrapper();
        }

        @Override
        public boolean hasXmlID() {
            return GenericJavaXmlElementMapping.this.getXmlID() != null;
        }

        @Override
        public boolean hasXmlIDREF() {
            return GenericJavaXmlElementMapping.this.getXmlIDREF() != null;
        }

        @Override
        public boolean hasXmlList() {
            return GenericJavaXmlElementMapping.this.isXmlList();
        }

        @Override
        public boolean hasXmlSchemaType() {
            return this.getXmlSchemaType() != null;
        }

        @Override
        public XmlSchemaType getXmlSchemaType() {
            return GenericJavaXmlElementMapping.this.getXmlSchemaType();
        }
    }

    protected class XmlIDREFContext
    extends AbstractJavaXmlNamedNodeMapping.XmlIDREFContext {
        protected XmlIDREFContext() {
            super(GenericJavaXmlElementMapping.this);
        }

        @Override
        public Iterable<GenericJavaXmlIDREF.ValidatableReference> getReferences() {
            return new SingleElementIterable((Object)new GenericJavaXmlIDREF.ValidatableReference(){

                @Override
                public String getFullyQualifiedType() {
                    return ((XmlIDREFContext)XmlIDREFContext.this).GenericJavaXmlElementMapping.this.xmlElement.getType();
                }

                @Override
                public TextRange getTypeValidationTextRange() {
                    return GenericJavaXmlElementMapping.this.getAnnotation() == null ? GenericJavaXmlElementMapping.this.getXmlIDREF().getValidationTextRange() : ((XmlIDREFContext)XmlIDREFContext.this).GenericJavaXmlElementMapping.this.xmlElement.getTypeTextRange();
                }

                @Override
                public XsdFeature getXsdFeature() {
                    return GenericJavaXmlElementMapping.this.getXsdFeature();
                }

                @Override
                public TextRange getXsdFeatureValidationTextRange() {
                    return ((XmlIDREFContext)XmlIDREFContext.this).GenericJavaXmlElementMapping.this.xmlElement.getQName().getNameValidationTextRange();
                }
            });
        }
    }
}

