/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.action.InternalImages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public final class AlignmentAction
extends SelectionAction {
    public static final String ID_ALIGN_BOTTOM = "org.eclipse.gef.align_bottom";
    public static final String ID_ALIGN_CENTER = "org.eclipse.gef.align_center";
    public static final String ID_ALIGN_LEFT = "org.eclipse.gef.align_left";
    public static final String ID_ALIGN_MIDDLE = "org.eclipse.gef.align_middle";
    public static final String ID_ALIGN_RIGHT = "org.eclipse.gef.align_right";
    public static final String ID_ALIGN_TOP = "org.eclipse.gef.align_top";
    private int alignment;
    private List operationSet;

    public AlignmentAction(IEditorPart editor, int align) {
        this((IWorkbenchPart)editor, align);
    }

    public AlignmentAction(IWorkbenchPart part, int align) {
        super(part);
        this.alignment = align;
        this.initUI();
    }

    protected Rectangle calculateAlignmentRectangle(Request request) {
        List editparts = this.getOperationSet(request);
        if (editparts == null || editparts.isEmpty()) {
            return null;
        }
        GraphicalEditPart part = null;
        part = this.alignment == 16 || this.alignment == 2 ? (GraphicalEditPart)editparts.get(editparts.size() - 1) : this.getFitnessPart(editparts);
        PrecisionRectangle rect = new PrecisionRectangle(part.getFigure().getBounds());
        part.getFigure().translateToAbsolute((Translatable)rect);
        return rect;
    }

    private GraphicalEditPart getFitnessPart(List editparts) {
        if (this.alignment == 16 || this.alignment == 2) {
            return null;
        }
        int positionComparor = Integer.MAX_VALUE;
        if (this.alignment == 1 || this.alignment == 8) {
            positionComparor = Integer.MAX_VALUE;
        } else if (this.alignment == 4 || this.alignment == 32) {
            positionComparor = Integer.MIN_VALUE;
        }
        GraphicalEditPart fitnessPart = null;
        for (GraphicalEditPart part : editparts) {
            Rectangle rectPart = part.getFigure().getBounds();
            switch (this.alignment) {
                case 1: {
                    if (rectPart.getLeft().x >= positionComparor) break;
                    fitnessPart = part;
                    positionComparor = rectPart.getLeft().x;
                    break;
                }
                case 4: {
                    if (rectPart.getRight().x <= positionComparor) break;
                    fitnessPart = part;
                    positionComparor = rectPart.getRight().x;
                    break;
                }
                case 8: {
                    if (rectPart.getTop().y >= positionComparor) break;
                    fitnessPart = part;
                    positionComparor = rectPart.getTop().y;
                    break;
                }
                case 32: {
                    if (rectPart.getBottom().y <= positionComparor) break;
                    fitnessPart = part;
                    positionComparor = rectPart.getBottom().y;
                }
            }
        }
        return fitnessPart;
    }

    protected boolean calculateEnabled() {
        this.operationSet = null;
        Command cmd = this.createAlignmentCommand();
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    private Command createAlignmentCommand() {
        AlignmentRequest request = new AlignmentRequest((Object)"align");
        request.setAlignmentRectangle(this.calculateAlignmentRectangle((Request)request));
        request.setAlignment(this.alignment);
        List editparts = this.getOperationSet((Request)request);
        if (editparts.size() < 2) {
            return null;
        }
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel(this.getText());
        int i = 0;
        while (i < editparts.size()) {
            EditPart editpart = (EditPart)editparts.get(i);
            command.add(editpart.getCommand((Request)request));
            ++i;
        }
        return command;
    }

    public void dispose() {
        this.operationSet = Collections.EMPTY_LIST;
        super.dispose();
    }

    protected List getOperationSet(Request request) {
        if (this.operationSet != null) {
            return this.operationSet;
        }
        List editparts = new ArrayList(this.getSelectedObjects());
        if (editparts.isEmpty() || !(editparts.get(0) instanceof GraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        Object primary = editparts.get(editparts.size() - 1);
        editparts = ToolUtilities.getSelectionWithoutDependants(editparts);
        ToolUtilities.filterEditPartsUnderstanding(editparts, (Request)request);
        if (editparts.size() < 2 || !editparts.contains(primary)) {
            return Collections.EMPTY_LIST;
        }
        EditPart parent = ((EditPart)editparts.get(0)).getParent();
        int i = 1;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (part.getParent() != parent) {
                return Collections.EMPTY_LIST;
            }
            ++i;
        }
        return editparts;
    }

    protected void initUI() {
        switch (this.alignment) {
            case 1: {
                this.setId(ID_ALIGN_LEFT);
                this.setText(EditorMessages.AlignmentAction_AlignLeftAction_Label);
                this.setToolTipText(EditorMessages.AlignmentAction_AlignLeftAction_Tooltip);
                this.setImageDescriptor(InternalImages.DESC_HORZ_ALIGN_LEFT);
                this.setDisabledImageDescriptor(InternalImages.DESC_HORZ_ALIGN_LEFT_DIS);
                break;
            }
            case 4: {
                this.setId(ID_ALIGN_RIGHT);
                this.setText(EditorMessages.AlignmentAction_AlignRightAction_Label);
                this.setToolTipText(EditorMessages.AlignmentAction_AlignRightAction_Tooltip);
                this.setImageDescriptor(InternalImages.DESC_HORZ_ALIGN_RIGHT);
                this.setDisabledImageDescriptor(InternalImages.DESC_HORZ_ALIGN_RIGHT_DIS);
                break;
            }
            case 8: {
                this.setId(ID_ALIGN_TOP);
                this.setText(EditorMessages.AlignmentAction_AlignTopAction_Label);
                this.setToolTipText(EditorMessages.AlignmentAction_AlignTopAction_Tooltip);
                this.setImageDescriptor(InternalImages.DESC_VERT_ALIGN_TOP);
                this.setDisabledImageDescriptor(InternalImages.DESC_VERT_ALIGN_TOP_DIS);
                break;
            }
            case 32: {
                this.setId(ID_ALIGN_BOTTOM);
                this.setText(EditorMessages.AlignmentAction_AlignBottomAction_Label);
                this.setToolTipText(EditorMessages.AlignmentAction_AlignBottomAction_Tooltip);
                this.setImageDescriptor(InternalImages.DESC_VERT_ALIGN_BOTTOM);
                this.setDisabledImageDescriptor(InternalImages.DESC_VERT_ALIGN_BOTTOM_DIS);
                break;
            }
            case 2: {
                this.setId(ID_ALIGN_CENTER);
                this.setText(EditorMessages.AlignmentAction_AlignCenterAction_Label);
                this.setToolTipText(EditorMessages.AlignmentAction_AlignCenterAction_Tooltip);
                this.setImageDescriptor(InternalImages.DESC_HORZ_ALIGN_CENTER);
                this.setDisabledImageDescriptor(InternalImages.DESC_HORZ_ALIGN_CENTER_DIS);
                break;
            }
            case 16: {
                this.setId(ID_ALIGN_MIDDLE);
                this.setText(EditorMessages.AlignmentAction_AlignMiddleAction_Label);
                this.setToolTipText(EditorMessages.AlignmentAction_AlignMiddleAction_Tooltip);
                this.setImageDescriptor(InternalImages.DESC_VERT_ALIGN_MIDDLE);
                this.setDisabledImageDescriptor(InternalImages.DESC_VERT_ALIGN_MIDDLE_DIS);
            }
        }
    }

    public void run() {
        this.operationSet = null;
        this.execute(this.createAlignmentCommand());
    }
}

