/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.tmf.remote.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.remote.ui.messages.RemoteMessages;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;

public class RemoteImportConnectionNodeElement
extends TracePackageElement {
    private static final String IMAGE_PATH = "icons/obj/connection_node.gif";
    private String fName;
    private String fURI;
    private RemoteSystemProxy fRemoteProxy;

    public RemoteImportConnectionNodeElement(TracePackageElement parent, String name, String uri) {
        super(parent);
        this.fName = name;
        this.fURI = uri;
    }

    public String getText() {
        return String.valueOf(this.fName) + " (" + this.fURI + ")";
    }

    public Image getImage() {
        return Activator.getDefault().getImageFromImageRegistry(IMAGE_PATH);
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getURI() {
        return this.fURI;
    }

    public void setURI(String uri) {
        this.fURI = uri;
    }

    public IStatus connect(@NonNull IProgressMonitor monitor) {
        RemoteSystemProxy proxy = this.fRemoteProxy;
        String name = this.fName;
        if (name == null) {
            return new Status(4, "org.eclipse.tracecompass.tmf.remote.ui", RemoteMessages.RemoteImportConnectionNodeElement_NodeNameNullError);
        }
        if (proxy == null) {
            try {
                URI hostUri = null;
                hostUri = URIUtil.fromString((String)this.fURI);
                if (hostUri == null) {
                    return new Status(4, "org.eclipse.tracecompass.tmf.remote.ui", RemoteMessages.RemoteImportConnectionNodeElement_UriNullError);
                }
                this.fRemoteProxy = proxy = new RemoteSystemProxy(TmfRemoteConnectionFactory.createConnection((URI)hostUri, (String)name));
            }
            catch (URISyntaxException e) {
                return new Status(4, "org.eclipse.tracecompass.tmf.remote.ui", MessageFormat.format(RemoteMessages.RemoteImportConnectionNodeElement_InvalidUriString, this.fURI), (Throwable)e);
            }
            catch (RemoteConnectionException e) {
                return new Status(4, "org.eclipse.tracecompass.tmf.remote.ui", MessageFormat.format(RemoteMessages.RemoteImportConnectionNodeElement_ConnectionFailure, this.fURI), (Throwable)e);
            }
        }
        try {
            proxy.connect(monitor);
            return Status.OK_STATUS;
        }
        catch (ExecutionException e) {
            return new Status(4, "org.eclipse.tracecompass.tmf.remote.ui", MessageFormat.format(RemoteMessages.RemoteImportConnectionNodeElement_ConnectionFailure, this.fURI), (Throwable)e);
        }
    }

    public void disconnect() {
        if (this.fRemoteProxy != null) {
            this.fRemoteProxy.dispose();
        }
    }

    public RemoteSystemProxy getRemoteSystemProxy() {
        return this.fRemoteProxy;
    }
}

