/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.tools.maintenance;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.ext.exasol.ExasolConstants;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableBase;
import org.jkiss.dbeaver.ext.exasol.tools.maintenance.ExasolBaseTableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.ui.UIUtils;

public class ExasolExportTableToolDialog
extends ExasolBaseTableToolDialog {
    private Combo cbRowSep;
    private Button btInclColNames;
    private Button btSelectDirectory;
    private Button btSelectCompress;
    private Text txColSep;
    private Text txStringSep;
    private Text txFileName;
    private Combo cbStringSepMode;
    private Combo cbEncoding;
    private Label selectedDirectory;
    private String encoding;
    private String sepMode;
    private String rowSep;
    private String filename;

    public ExasolExportTableToolDialog(IWorkbenchPartSite partSite, Collection<ExasolTableBase> selectedTables) {
        super(partSite, ExasolMessages.dialog_table_tools_export_title, selectedTables);
    }

    protected void generateObjectCommand(List<String> sql, ExasolTableBase object) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("EXPORT ");
        sb.append(object.getFullyQualifiedName(DBPEvaluationContext.DML));
        sb.append(" INTO LOCAL CSV FILE '");
        if (this.selectedDirectory.getText() != null) {
            sb.append(this.selectedDirectory.getText());
        }
        sb.append(super.replaceVars(this.filename, object));
        sb.append(this.btSelectCompress.getSelection() ? ".csv.gz'" : ".csv'");
        sb.append(" ENCODING = '" + this.encoding + "'");
        sb.append(" ROW SEPARATOR = '" + this.rowSep + "'");
        sb.append(" COLUMN SEPARATOR = '" + this.txColSep.getText().replaceAll("'", "''") + "'");
        sb.append(" COLUMN DELIMITER = '" + this.txStringSep.getText().replaceAll("'", "''") + "'");
        sb.append(" DELIMIT = " + this.sepMode);
        if (this.btInclColNames.getSelection()) {
            sb.append(" WITH COLUMN NAMES");
        }
        sql.add(sb.toString());
    }

    protected void createControls(final Composite parent) {
        Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)ExasolMessages.dialog_table_tools_options, (int)1, (int)0, (int)0);
        optionsGroup.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)optionsGroup, 2);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.btSelectDirectory = UIUtils.createPushButton((Composite)composite, (String)ExasolMessages.dialog_table_open_output_directory, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
                String directory = dialog.open();
                if (directory != null) {
                    ExasolExportTableToolDialog.this.selectedDirectory.setVisible(true);
                    ExasolExportTableToolDialog.this.selectedDirectory.setText(String.valueOf(directory) + File.separatorChar);
                } else {
                    ExasolExportTableToolDialog.this.selectedDirectory.setVisible(false);
                }
                ExasolExportTableToolDialog.this.updateSQL();
            }
        });
        this.selectedDirectory = UIUtils.createLabel((Composite)composite, (String)"");
        this.selectedDirectory.setVisible(false);
        this.filename = "${schema}_${table}_${date}";
        this.txFileName = UIUtils.createLabelText((Composite)composite, (String)ExasolMessages.dialog_table_tools_file_template, (String)this.filename);
        this.txFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ExasolExportTableToolDialog.this.filename = ExasolExportTableToolDialog.this.txFileName.getText();
                ExasolExportTableToolDialog.this.updateSQL();
            }
        });
        this.btSelectCompress = UIUtils.createCheckbox((Composite)composite, (String)ExasolMessages.dialog_table_tools_export_compress, (boolean)false);
        this.btSelectCompress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExasolExportTableToolDialog.this.updateSQL();
            }
        });
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.btInclColNames = UIUtils.createCheckbox((Composite)composite, (String)ExasolMessages.dialog_table_tools_column_heading, (boolean)true);
        this.btInclColNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExasolExportTableToolDialog.this.updateSQL();
            }
        });
        UIUtils.createPlaceholder((Composite)composite, (int)1);
        this.cbEncoding = UIUtils.createLabelCombo((Composite)composite, (String)ExasolMessages.dialog_table_tools_encoding, (int)12);
        for (String enc : ExasolConstants.encodings) {
            this.cbEncoding.add(enc);
        }
        this.cbEncoding.select(0);
        this.encoding = ExasolConstants.encodings.get(0);
        this.cbEncoding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExasolExportTableToolDialog.this.encoding = ExasolConstants.encodings.get(ExasolExportTableToolDialog.this.cbEncoding.getSelectionIndex());
                ExasolExportTableToolDialog.this.updateSQL();
            }
        });
        this.cbRowSep = UIUtils.createLabelCombo((Composite)composite, (String)ExasolMessages.dialog_table_tools_string_sep_mode, (int)12);
        for (String mode : ExasolConstants.rowSeperators) {
            this.cbRowSep.add(mode);
        }
        this.cbRowSep.select(0);
        this.rowSep = ExasolConstants.rowSeperators.get(0);
        this.cbRowSep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExasolExportTableToolDialog.this.rowSep = ExasolConstants.rowSeperators.get(ExasolExportTableToolDialog.this.cbRowSep.getSelectionIndex());
                ExasolExportTableToolDialog.this.updateSQL();
            }
        });
        this.cbStringSepMode = UIUtils.createLabelCombo((Composite)composite, (String)ExasolMessages.dialog_table_tools_string_sep_mode, (int)12);
        for (String mode : ExasolConstants.stringSepModes) {
            this.cbStringSepMode.add(mode);
        }
        this.cbStringSepMode.select(0);
        this.sepMode = ExasolConstants.stringSepModes.get(0);
        this.cbStringSepMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExasolExportTableToolDialog.this.sepMode = ExasolConstants.stringSepModes.get(ExasolExportTableToolDialog.this.cbStringSepMode.getSelectionIndex());
                ExasolExportTableToolDialog.this.updateSQL();
            }
        });
        this.txColSep = UIUtils.createLabelText((Composite)composite, (String)ExasolMessages.dialog_table_tools_column_sep, (String)";");
        this.txColSep.setTextLimit(1);
        this.txColSep.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ExasolExportTableToolDialog.this.updateSQL();
            }
        });
        this.txStringSep = UIUtils.createLabelText((Composite)composite, (String)ExasolMessages.dialog_table_tools_string_sep, (String)"\"");
        this.txStringSep.setTextLimit(1);
        this.txStringSep.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ExasolExportTableToolDialog.this.updateSQL();
            }
        });
        this.createObjectsSelector(parent);
    }
}

