/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetDataReceiver;
import org.jkiss.dbeaver.ui.controls.resultset.StatusDetailsDialog;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class StatusLabel
extends Composite {
    private final IResultSetController viewer;
    private final Text statusText;
    private DBPMessageType messageType;

    public StatusLabel(@NotNull Composite parent, int style, @Nullable IResultSetController viewer) {
        super(parent, 0);
        this.viewer = viewer;
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 3;
        this.setLayout((Layout)layout);
        ToolBar tb = new ToolBar((Composite)this, 0x800100);
        CSSUtils.setCSSClass((Widget)tb, (String)"coloredByConnectionType");
        ToolItem detailsIcon = new ToolItem(tb, 0);
        detailsIcon.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.TEXTFIELD));
        tb.setLayoutData((Object)new GridData(32));
        detailsIcon.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatusLabel.this.showDetails();
            }
        });
        this.statusText = new Text((Composite)this, 12);
        if (RuntimeUtils.isPlatformWindows()) {
            this.statusText.setBackground(null);
        } else {
            this.statusText.setBackground(parent.getBackground());
        }
        GridData gd = new GridData(768);
        this.statusText.setLayoutData((Object)gd);
        this.statusText.addTraverseListener(e -> {
            if (e.detail == 4) {
                this.showDetails();
            }
        });
        if (viewer != null) {
            TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)viewer.getSite(), (Control)this.statusText);
            UIUtils.addDefaultEditActionsSupport((IServiceLocator)viewer.getSite(), (Control)this.statusText);
        }
    }

    protected void showDetails() {
        DBDDataReceiver dataReceiver = this.viewer.getDataReceiver();
        if (dataReceiver instanceof ResultSetDataReceiver) {
            StatusDetailsDialog dialog = new StatusDetailsDialog(this.viewer.getSite().getShell(), this.getMessage(), ((ResultSetDataReceiver)dataReceiver).getErrorList());
            dialog.open();
        }
    }

    public void setStatus(String message) {
        this.setStatus(message, DBPMessageType.INFORMATION);
    }

    public void setStatus(String message, DBPMessageType messageType) {
        if (this.statusText.isDisposed()) {
            return;
        }
        this.messageType = messageType;
        switch (messageType) {
            case ERROR: {
                break;
            }
            case WARNING: {
                break;
            }
        }
        if (message == null) {
            message = "???";
        }
        this.statusText.setText(CommonUtils.getSingleLineString((String)message));
        if (messageType != DBPMessageType.INFORMATION) {
            this.statusText.setToolTipText(message);
        } else {
            this.statusText.setToolTipText(null);
        }
    }

    public String getMessage() {
        return this.statusText.getText();
    }

    public DBPMessageType getMessageType() {
        return this.messageType;
    }

    public void setUpdateListener(Runnable runnable) {
    }
}

