(function() {
  var Dialog, MoveDialog, fs, path, repoForPath,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  path = require('path');

  fs = require('fs-plus');

  Dialog = require('./dialog');

  repoForPath = require("./helpers").repoForPath;

  module.exports = MoveDialog = (function(superClass) {
    extend(MoveDialog, superClass);

    function MoveDialog(initialPath, arg) {
      var prompt;
      this.initialPath = initialPath;
      this.willMove = arg.willMove, this.onMove = arg.onMove, this.onMoveFailed = arg.onMoveFailed;
      if (fs.isDirectorySync(this.initialPath)) {
        prompt = 'Enter the new path for the directory.';
      } else {
        prompt = 'Enter the new path for the file.';
      }
      MoveDialog.__super__.constructor.call(this, {
        prompt: prompt,
        initialPath: atom.project.relativize(this.initialPath),
        select: true,
        iconClass: 'icon-arrow-right'
      });
    }

    MoveDialog.prototype.onConfirm = function(newPath) {
      var directoryPath, error, repo, rootPath;
      newPath = newPath.replace(/\s+$/, '');
      if (!path.isAbsolute(newPath)) {
        rootPath = atom.project.relativizePath(this.initialPath)[0];
        newPath = path.join(rootPath, newPath);
        if (!newPath) {
          return;
        }
      }
      if (this.initialPath === newPath) {
        this.close();
        return;
      }
      if (!this.isNewPathValid(newPath)) {
        this.showError("'" + newPath + "' already exists.");
        return;
      }
      directoryPath = path.dirname(newPath);
      try {
        if (typeof this.willMove === "function") {
          this.willMove({
            initialPath: this.initialPath,
            newPath: newPath
          });
        }
        if (!fs.existsSync(directoryPath)) {
          fs.makeTreeSync(directoryPath);
        }
        fs.moveSync(this.initialPath, newPath);
        if (typeof this.onMove === "function") {
          this.onMove({
            initialPath: this.initialPath,
            newPath: newPath
          });
        }
        if (repo = repoForPath(newPath)) {
          repo.getPathStatus(this.initialPath);
          repo.getPathStatus(newPath);
        }
        return this.close();
      } catch (error1) {
        error = error1;
        this.showError(error.message + ".");
        return typeof this.onMoveFailed === "function" ? this.onMoveFailed({
          initialPath: this.initialPath,
          newPath: newPath
        }) : void 0;
      }
    };

    MoveDialog.prototype.isNewPathValid = function(newPath) {
      var newStat, oldStat;
      try {
        oldStat = fs.statSync(this.initialPath);
        newStat = fs.statSync(newPath);
        return this.initialPath.toLowerCase() === newPath.toLowerCase() && oldStat.dev === newStat.dev && oldStat.ino === newStat.ino;
      } catch (error1) {
        return true;
      }
    };

    return MoveDialog;

  })(Dialog);

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
