(function() {
  var SelectionCountView, _;

  _ = require('underscore-plus');

  module.exports = SelectionCountView = (function() {
    function SelectionCountView() {
      var ref;
      this.element = document.createElement('status-bar-selection');
      this.element.classList.add('selection-count', 'inline-block');
      this.tooltipElement = document.createElement('div');
      this.tooltipDisposable = atom.tooltips.add(this.element, {
        item: this.tooltipElement
      });
      this.formatString = (ref = atom.config.get('status-bar.selectionCountFormat')) != null ? ref : '(%L, %C)';
      this.activeItemSubscription = atom.workspace.onDidChangeActiveTextEditor((function(_this) {
        return function() {
          return _this.subscribeToActiveTextEditor();
        };
      })(this));
      this.subscribeToConfig();
      this.subscribeToActiveTextEditor();
    }

    SelectionCountView.prototype.destroy = function() {
      var ref, ref1;
      this.activeItemSubscription.dispose();
      if ((ref = this.selectionSubscription) != null) {
        ref.dispose();
      }
      if ((ref1 = this.configSubscription) != null) {
        ref1.dispose();
      }
      return this.tooltipDisposable.dispose();
    };

    SelectionCountView.prototype.subscribeToConfig = function() {
      var ref;
      if ((ref = this.configSubscription) != null) {
        ref.dispose();
      }
      return this.configSubscription = atom.config.observe('status-bar.selectionCountFormat', (function(_this) {
        return function(value) {
          _this.formatString = value != null ? value : '(%L, %C)';
          return _this.scheduleUpdateCount();
        };
      })(this));
    };

    SelectionCountView.prototype.subscribeToActiveTextEditor = function() {
      var activeEditor, ref, selectionsMarkerLayer;
      if ((ref = this.selectionSubscription) != null) {
        ref.dispose();
      }
      activeEditor = this.getActiveTextEditor();
      selectionsMarkerLayer = activeEditor != null ? activeEditor.selectionsMarkerLayer : void 0;
      this.selectionSubscription = selectionsMarkerLayer != null ? selectionsMarkerLayer.onDidUpdate(this.scheduleUpdateCount.bind(this)) : void 0;
      return this.scheduleUpdateCount();
    };

    SelectionCountView.prototype.getActiveTextEditor = function() {
      return atom.workspace.getActiveTextEditor();
    };

    SelectionCountView.prototype.scheduleUpdateCount = function() {
      if (!this.scheduledUpdate) {
        this.scheduledUpdate = true;
        return atom.views.updateDocument((function(_this) {
          return function() {
            _this.updateCount();
            return _this.scheduledUpdate = false;
          };
        })(this));
      }
    };

    SelectionCountView.prototype.updateCount = function() {
      var count, lineCount, range, ref, ref1;
      count = (ref = this.getActiveTextEditor()) != null ? ref.getSelectedText().length : void 0;
      range = (ref1 = this.getActiveTextEditor()) != null ? ref1.getSelectedBufferRange() : void 0;
      lineCount = range != null ? range.getRowCount() : void 0;
      if ((range != null ? range.end.column : void 0) === 0) {
        lineCount -= 1;
      }
      if (count > 0) {
        this.element.textContent = this.formatString.replace('%L', lineCount).replace('%C', count);
        return this.tooltipElement.textContent = (_.pluralize(lineCount, 'line')) + ", " + (_.pluralize(count, 'character')) + " selected";
      } else {
        this.element.textContent = '';
        return this.tooltipElement.textContent = '';
      }
    };

    return SelectionCountView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
