"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _author = _interopRequireDefault(require("../models/author"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _helpers = require("../helpers");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CoAuthorForm extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'confirm', 'cancel', 'onNameChange', 'onEmailChange', 'validate', 'focusFirstInput');
    this.state = {
      name: this.props.name,
      email: '',
      submitDisabled: true
    };
  }

  componentDidMount() {
    setTimeout(this.focusFirstInput);
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-CoAuthorForm native-key-bindings"
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: ".github-CoAuthorForm"
    }, _react["default"].createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancel
    }), _react["default"].createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.confirm
    })), _react["default"].createElement("label", {
      className: "github-CoAuthorForm-row"
    }, _react["default"].createElement("span", {
      className: "github-CoAuthorForm-label"
    }, "Name:"), _react["default"].createElement("input", {
      type: "text",
      placeholder: "Co-author name",
      ref: e => this.nameInput = e,
      className: "input-text github-CoAuthorForm-name",
      value: this.state.name,
      onChange: this.onNameChange,
      tabIndex: "1"
    })), _react["default"].createElement("label", {
      className: "github-CoAuthorForm-row"
    }, _react["default"].createElement("span", {
      className: "github-CoAuthorForm-label"
    }, "Email:"), _react["default"].createElement("input", {
      type: "email",
      placeholder: "foo@bar.com",
      ref: e => this.emailInput = e,
      className: "input-text github-CoAuthorForm-email",
      value: this.state.email,
      onChange: this.onEmailChange,
      tabIndex: "2"
    })), _react["default"].createElement("footer", {
      className: "github-CoAuthorForm-row has-buttons"
    }, _react["default"].createElement("button", {
      className: "btn github-CancelButton",
      tabIndex: "3",
      onClick: this.cancel
    }, "Cancel"), _react["default"].createElement("button", {
      className: "btn btn-primary",
      disabled: this.state.submitDisabled,
      tabIndex: "4",
      onClick: this.confirm
    }, "Add Co-Author")));
  }

  confirm() {
    if (this.isInputValid()) {
      this.props.onSubmit(new _author["default"](this.state.email, this.state.name));
    }
  }

  cancel() {
    this.props.onCancel();
  }

  onNameChange(e) {
    this.setState({
      name: e.target.value
    }, this.validate);
  }

  onEmailChange(e) {
    this.setState({
      email: e.target.value
    }, this.validate);
  }

  validate() {
    if (this.isInputValid()) {
      this.setState({
        submitDisabled: false
      });
    }
  }

  isInputValid() {
    // email validation with regex has a LOT of corner cases, dawg.
    // https://stackoverflow.com/questions/48055431/can-it-cause-harm-to-validate-email-addresses-with-a-regex
    // to avoid bugs for users with nonstandard email addresses,
    // just check to make sure email address contains `@` and move on with our lives.
    return this.state.name && this.state.email.includes('@');
  }

  focusFirstInput() {
    this.nameInput.focus();
  }

}

exports["default"] = CoAuthorForm;

_defineProperty(CoAuthorForm, "propTypes", {
  commandRegistry: _propTypes["default"].object.isRequired,
  onSubmit: _propTypes["default"].func,
  onCancel: _propTypes["default"].func,
  name: _propTypes["default"].string
});

_defineProperty(CoAuthorForm, "defaultProps", {
  onSubmit: () => {},
  onCancel: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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