/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EnumConverter
implements Converter {
    public static final EnumConverter INSTANCE = new EnumConverter();

    EnumConverter() {
    }

    @Override
    public Object convert(JSON jSON, JSON.Context context, Object object, Class<?> clazz, Type type) throws Exception {
        Enum[] enumArray;
        if (object instanceof Map) {
            object = ((Map)object).get(null);
        } else if (object instanceof List) {
            enumArray = (Enum[])object;
            object = !enumArray.isEmpty() ? enumArray.get(0) : null;
        }
        enumArray = (Enum[])clazz.getEnumConstants();
        if (object instanceof Number) {
            return enumArray[((Number)object).intValue()];
        }
        if (object instanceof Boolean) {
            return enumArray[(Boolean)object != false ? 1 : 0];
        }
        if (object != null) {
            String string = object.toString().trim();
            if (string.length() == 0) {
                return null;
            }
            if (Character.isDigit(string.charAt(0))) {
                return enumArray[Integer.parseInt(string)];
            }
            for (Enum enum_ : enumArray) {
                if (!string.equals(enum_.name())) continue;
                return enum_;
            }
            if (context.getEnumStyle() != null) {
                for (Enum enum_ : enumArray) {
                    if (!string.equals(context.getEnumStyle().to(enum_.name()))) continue;
                    return enum_;
                }
            }
            throw new IllegalArgumentException(string + " is not " + clazz);
        }
        return null;
    }
}

