/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.google.common.collect.Sets;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.jetbrains.extensions.python.PyClassExtKt;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.PyPsiLocationWithFixedClass;
import com.jetbrains.python.testing.PyTestsSharedKt;
import com.jetbrains.python.testing.TestRunnerService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonUnitTestUtil {
    public static final String TESTCASE_SETUP_NAME = "setUp";
    public static final Set<String> PYTHON_TEST_QUALIFIED_CLASSES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"unittest.TestCase", "unittest.case.TestCase"}));

    private PythonUnitTestUtil() {
    }

    public static boolean isTestFile(@NotNull PyFile file, @NotNull ThreeState testCaseClassRequired, @Nullable TypeEvalContext context) {
        if (file == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(0);
        }
        if (testCaseClassRequired == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(1);
        }
        if (file.getTopLevelClasses().stream().anyMatch(o -> PythonUnitTestUtil.isTestClass(o, testCaseClassRequired, context))) {
            return true;
        }
        if (PythonUnitTestUtil.isTestCaseClassRequired((PsiElement)file, testCaseClassRequired)) {
            return false;
        }
        return file.getName().startsWith("test_") || file.getTopLevelFunctions().stream().anyMatch(o -> PythonUnitTestUtil.isTestFunction(o, testCaseClassRequired, context));
    }

    @Deprecated
    public static boolean isTestCaseClass(@NotNull PyClass cls, @Nullable TypeEvalContext context) {
        if (cls == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(2);
        }
        return PythonUnitTestUtil.isTestClass(cls, ThreeState.YES, context);
    }

    public static boolean isTestClass(@NotNull PyClass cls, @NotNull ThreeState testCaseClassRequired, @Nullable TypeEvalContext context) {
        boolean inheritsTestCase;
        if (cls == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(3);
        }
        if (testCaseClassRequired == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(4);
        }
        boolean testCaseOnly = PythonUnitTestUtil.isTestCaseClassRequired((PsiElement)cls, testCaseClassRequired);
        if (context == null) {
            context = TypeEvalContext.codeInsightFallback(cls.getProject());
        }
        if (inheritsTestCase = PyClassExtKt.inherits(cls, context, PYTHON_TEST_QUALIFIED_CLASSES)) {
            return true;
        }
        if (testCaseOnly) {
            return false;
        }
        String className = cls.getName();
        if (className == null) {
            return false;
        }
        if (!className.startsWith("Test") && !className.endsWith("Test")) {
            return false;
        }
        Ref result = new Ref((Object)false);
        cls.visitMethods((Processor<PyFunction>)((Processor)function -> {
            String name = function.getName();
            if (name != null && name.startsWith("test")) {
                result.set((Object)true);
                return false;
            }
            return true;
        }), true, context);
        return (Boolean)result.get();
    }

    public static boolean isTestFunction(@NotNull PyFunction function, @NotNull ThreeState testCaseClassRequired, @Nullable TypeEvalContext context) {
        String name;
        if (function == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(5);
        }
        if (testCaseClassRequired == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(6);
        }
        if ((name = function.getName()) == null || !name.startsWith("test")) {
            return false;
        }
        PyClass aClass = function.getContainingClass();
        if (!PythonUnitTestUtil.isTestCaseClassRequired(function, testCaseClassRequired) && aClass == null) {
            return true;
        }
        return aClass != null && PythonUnitTestUtil.isTestClass(aClass, testCaseClassRequired, context);
    }

    @Deprecated
    public static boolean isUnitTestCaseClass(PyClass cls) {
        return PythonUnitTestUtil.isTestClass(cls, ThreeState.YES, null);
    }

    private static boolean isTestCaseClassRequired(@NotNull PsiElement anchor, @NotNull ThreeState userProvidedValue) {
        if (anchor == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(7);
        }
        if (userProvidedValue == null) {
            PythonUnitTestUtil.$$$reportNull$$$0(8);
        }
        if (userProvidedValue != ThreeState.UNSURE) {
            return userProvidedValue.toBoolean();
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)anchor);
        if (module2 == null) {
            return true;
        }
        return PyTestsSharedKt.getRunnersThatRequireTestCaseClass().contains(TestRunnerService.getInstance(module2).getProjectConfiguration());
    }

    public static List<Location> findLocations(@NotNull Project project, @NotNull String fileName, @Nullable String className, @Nullable String methodName) {
        ArrayList<Location> locations;
        block10: {
            block9: {
                if (project == null) {
                    PythonUnitTestUtil.$$$reportNull$$$0(9);
                }
                if (fileName == null) {
                    PythonUnitTestUtil.$$$reportNull$$$0(10);
                }
                if (fileName.contains("%")) {
                    fileName = fileName.substring(0, fileName.lastIndexOf("%"));
                }
                locations = new ArrayList<Location>();
                if (methodName == null && className == null) {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
                    if (virtualFile == null) {
                        return locations;
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (psiFile != null) {
                        locations.add((Location)new PsiLocation(project, (PsiElement)psiFile));
                    }
                }
                if (className == null) break block9;
                for (PyClass cls : PyClassNameIndex.find(className, project, false)) {
                    ProgressManager.checkCanceled();
                    PsiFile containingFile = cls.getContainingFile();
                    VirtualFile virtualFile = containingFile.getVirtualFile();
                    String clsFileName = virtualFile == null ? containingFile.getName() : virtualFile.getPath();
                    String clsFileNameWithoutExt = FileUtil.getNameWithoutExtension((String)clsFileName);
                    if (!clsFileNameWithoutExt.endsWith(fileName) && !fileName.equals(clsFileName)) continue;
                    if (methodName == null) {
                        locations.add((Location)new PsiLocation(project, (PsiElement)cls));
                        continue;
                    }
                    PyFunction method = cls.findMethodByName(methodName, true, null);
                    if (method == null) continue;
                    locations.add((Location)new PyPsiLocationWithFixedClass(project, method, cls));
                }
                break block10;
            }
            if (methodName == null) break block10;
            for (PyFunction function : PyFunctionNameIndex.find(methodName, project)) {
                PsiFile containingFile;
                VirtualFile virtualFile;
                String clsFileName;
                String clsFileNameWithoutExt;
                ProgressManager.checkCanceled();
                if (function.getContainingClass() != null || !(clsFileNameWithoutExt = FileUtil.getNameWithoutExtension((String)(clsFileName = (virtualFile = (containingFile = function.getContainingFile()).getVirtualFile()) == null ? containingFile.getName() : virtualFile.getPath()))).endsWith(fileName)) continue;
                locations.add((Location)new PsiLocation(project, (PsiElement)function));
            }
        }
        return locations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseClassRequired";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userProvidedValue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/testing/PythonUnitTestUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestCaseClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestFunction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestCaseClassRequired";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "findLocations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

