/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.border;

import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;

public class IdeaTitledBorder
extends TitledBorder {
    private final TitledSeparator titledSeparator;
    private final Insets insideInsets;
    private final Insets outsideInsets;
    private boolean myShowLine = true;

    public IdeaTitledBorder(String title, int indent, Insets insets) {
        super(title);
        this.titledSeparator = new TitledSeparator(title);
        this.titledSeparator.setText(title);
        DialogUtil.registerMnemonic(this.titledSeparator.getLabel(), null);
        this.outsideInsets = JBInsets.create((Insets)insets);
        this.insideInsets = new JBInsets(5, indent, 0, 0);
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.titledSeparator.setText(title);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int labelX = x + this.outsideInsets.left;
        int labelY = y + this.outsideInsets.top;
        TitledSeparator titledSeparator = this.getTitledSeparator(c);
        JLabel label = titledSeparator.getLabel();
        Dimension labelSize = label.getPreferredSize();
        label.setSize(labelSize);
        g.translate(labelX, labelY);
        label.paint(g);
        int separatorX = labelX + labelSize.width + 6;
        int separatorY = labelY + (UIUtil.isUnderAquaLookAndFeel() ? 2 : labelSize.height / 2 - 1);
        int separatorW = Math.max(0, width - separatorX - 3);
        int separatorH = 2;
        JSeparator separator = titledSeparator.getSeparator();
        separator.setSize(separatorW, separatorH);
        g.translate(separatorX - labelX, separatorY - labelY);
        if (this.myShowLine) {
            separator.paint(g);
        }
        g.translate(-separatorX, -separatorY);
    }

    private TitledSeparator getTitledSeparator(Component c) {
        this.titledSeparator.setEnabled(c.isEnabled());
        return this.titledSeparator;
    }

    public IdeaTitledBorder setShowLine(boolean showLine) {
        this.myShowLine = showLine;
        return this;
    }

    public void acceptMinimumSize(Component c) {
        Dimension minimumSize = this.getMinimumSize(c);
        c.setMinimumSize(new Dimension(Math.max(minimumSize.width, c.getMinimumSize().width), Math.max(minimumSize.height, c.getMinimumSize().height)));
    }

    @Override
    public Dimension getMinimumSize(Component c) {
        Insets insets = this.getBorderInsets(c);
        Dimension minSize = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        Dimension separatorSize = this.getTitledSeparator(c).getPreferredSize();
        minSize.width = Math.max(minSize.width, separatorSize.width + this.outsideInsets.left + this.outsideInsets.right);
        return minSize;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = (int)((double)insets.top + (this.getTitledSeparator(c).getPreferredSize().getHeight() - 7.0 - 5.0));
        insets.top += 4;
        insets.top += this.insideInsets.top;
        insets.left += this.insideInsets.left;
        insets.bottom += this.insideInsets.bottom;
        insets.right += this.insideInsets.right;
        insets.top += this.outsideInsets.top;
        insets.left += this.outsideInsets.left;
        insets.bottom += this.outsideInsets.bottom;
        insets.right += this.outsideInsets.right;
        return insets;
    }
}

