/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.Processor;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PythonHelpersLocator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javafx.application.Platform;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.IpnbFileType;
import org.markdown4j.CodeBlockEmitter;
import org.markdown4j.ExtDecorator;
import org.markdown4j.IncludePlugin;
import org.markdown4j.Plugin;
import org.markdown4j.WebSequencePlugin;
import org.markdown4j.YumlPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class IpnbJfxUtils {
    private static final Logger LOG = Logger.getInstance(IpnbJfxUtils.class);
    private static final String ourStyle = "<html><head><style>#mydiv\n{\nmin-width: %spx;\n}</style>";
    private static final String ourBody = "</head><body><div id=\"mydiv\">";
    private static final String ourMathJaxPrefix = "<html><head><style>#mydiv\n{\nmin-width: %spx;\n}</style><script type=\"text/x-mathjax-config\">\n            MathJax.Hub.Config({\n                tex2jax: {\n                    inlineMath: [ ['$','$'], [\"\\\\(\",\"\\\\)\"] ],\n                    displayMath: [ ['$$','$$'], [\"\\\\[\",\"\\\\]\"] ],\n                    processEscapes: true,\n                    processEnvironments: true\n                },\n                displayAlign: 'center',\n                \"HTML-CSS\": {\n                    styles: {'#mydiv': {\"font-size\": %s}},\n                    preferredFont: null,\n                    linebreaks: { automatic: true }\n                }\n            });\n</script><script type=\"text/javascript\"\n src=\" %s?config=TeX-AMS_HTML-full\">\n </script></head><body><div id=\"mydiv\">";
    private static final String ourPrefix = "<html><head><style>#mydiv\n{\nmin-width: %spx;\n}</style></head><body><div id=\"mydiv\">";
    private static final String ourPostfix = "</div></body></html>";
    private static URL ourStyleUrl;
    private static final int renderingDelay = 10;

    private static void runFX(@NotNull Runnable r) {
        if (r == null) {
            IpnbJfxUtils.$$$reportNull$$$0(0);
        }
        IdeEventQueue.unsafeNonblockingExecute((Runnable)r);
    }

    public static JComponent createHtmlPanel(@NotNull String source, int width) {
        if (source == null) {
            IpnbJfxUtils.$$$reportNull$$$0(1);
        }
        JFXPanel javafxPanel = new JFXPanel(){

            protected void processMouseWheelEvent(MouseWheelEvent e) {
                Container parent = this.getParent();
                MouseEvent parentEvent = SwingUtilities.convertMouseEvent((Component)((Object)this), e, parent);
                parent.dispatchEvent(parentEvent);
            }
        };
        ApplicationManager.getApplication().invokeLater(() -> IpnbJfxUtils.runFX(() -> Platform.runLater(() -> {
            WebView webView = new WebView();
            webView.setContextMenuEnabled(false);
            webView.setOnDragDetected(event -> {});
            WebEngine engine = webView.getEngine();
            IpnbJfxUtils.initHyperlinkListener(engine);
            boolean hasMath = source.contains("$");
            if (hasMath) {
                engine.setOnStatusChanged(event -> {
                    String data = (String)event.getData();
                    if (data != null && data.isEmpty()) {
                        IpnbJfxUtils.adjustHeight(webView, javafxPanel, source);
                    }
                });
            } else {
                engine.getLoadWorker().stateProperty().addListener((observable, oldValue, newValue) -> {
                    if (newValue == Worker.State.SUCCEEDED) {
                        IpnbJfxUtils.adjustHeight(webView, javafxPanel, source);
                    }
                });
            }
            String prefix = hasMath ? String.format(ourMathJaxPrefix, width - 500, EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize(), PythonHelpersLocator.getHelperFile((String)"/MathJax/MathJax.js").toURI()) : String.format(ourPrefix, width - 500);
            String content = prefix + IpnbJfxUtils.convertToHtml(source) + ourPostfix;
            engine.loadContent(content);
            Scene scene = new Scene((Parent)webView, 0.0, 0.0);
            javafxPanel.setScene(scene);
            IpnbJfxUtils.updateLaf(LafManager.getInstance().getCurrentLookAndFeel() instanceof DarculaLookAndFeelInfo, engine, javafxPanel);
        })));
        return javafxPanel;
    }

    private static String convertToHtml(@NotNull String source) {
        if (source == null) {
            IpnbJfxUtils.$$$reportNull$$$0(2);
        }
        if (source.trim().startsWith("<iframe")) {
            return source;
        }
        String result = IpnbJfxUtils.wrapMath(source);
        ExtDecorator decorator = new ExtDecorator();
        Configuration.Builder builder = Configuration.builder().forceExtentedProfile().registerPlugins(new Plugin[]{new YumlPlugin(), new WebSequencePlugin(), new IncludePlugin()}).setDecorator((Decorator)decorator).setCodeBlockEmitter((BlockEmitter)new CodeBlockEmitter());
        String processed = Processor.process((String)result, (Configuration)builder.build());
        processed = IpnbJfxUtils.unwrapMath(processed);
        return processed;
    }

    private static String unwrapMath(@NotNull String processed) {
        if (processed == null) {
            IpnbJfxUtils.$$$reportNull$$$0(3);
        }
        processed = processed.replaceAll("<code>\\$\\$", "\\$\\$");
        processed = processed.replaceAll("\\$\\$</code>", "\\$\\$");
        processed = processed.replaceAll("\\$</code>", "\\$");
        processed = processed.replaceAll("<code>\\$", "\\$");
        return processed;
    }

    @NotNull
    private static String wrapMath(@NotNull String source) {
        String substring;
        boolean single;
        if (source == null) {
            IpnbJfxUtils.$$$reportNull$$$0(4);
        }
        StringBuilder result = new StringBuilder();
        boolean inMath = false;
        int start = 0;
        int end = StringUtil.indexOf((CharSequence)source, (CharSequence)"$");
        boolean bl = single = end + 1 >= source.length() || source.charAt(end + 1) != '$';
        while (end >= 0) {
            substring = source.substring(start, end);
            if (start != 0) {
                result.append(IpnbJfxUtils.escapeMath(inMath, single));
            }
            result.append(substring);
            inMath = !inMath;
            single = end + 1 >= source.length() || source.charAt(end + 1) != '$';
            start = end + (single ? 1 : 2);
            end = StringUtil.indexOf((CharSequence)source, (CharSequence)"$", (int)start);
        }
        if (start != 0) {
            result.append(IpnbJfxUtils.escapeMath(inMath, single));
        }
        substring = source.substring(start);
        result.append(substring);
        String string = result.toString();
        if (string == null) {
            IpnbJfxUtils.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static String escapeMath(boolean inMath, boolean single) {
        if (single) {
            return inMath ? "`$" : "$`";
        }
        return inMath ? "`$$" : "$$`";
    }

    private static void initHyperlinkListener(@NotNull WebEngine engine) {
        if (engine == null) {
            IpnbJfxUtils.$$$reportNull$$$0(6);
        }
        engine.getLoadWorker().stateProperty().addListener((ov, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                HyperlinkListener listener = new HyperlinkListener(engine);
                IpnbJfxUtils.addListenerToAllHyperlinkItems(engine, listener);
            }
        });
    }

    private static void addListenerToAllHyperlinkItems(WebEngine engine, EventListener listener) {
        Document doc = engine.getDocument();
        if (doc != null) {
            NodeList nodeList = doc.getElementsByTagName("a");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ((EventTarget)((Object)nodeList.item(i))).addEventListener("click", listener, false);
            }
        }
    }

    private static void adjustHeight(WebView webView, JFXPanel javafxPanel, String source) {
        Element mydiv;
        WebEngine engine = webView.getEngine();
        Document document = engine.getDocument();
        if (document != null && (mydiv = document.getElementById("mydiv")) != null) {
            int width;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Object heightObject = engine.executeScript("document.height");
            int height = heightObject instanceof Integer ? (Integer)heightObject : 0;
            Object widthObject = engine.executeScript("document.width");
            int n = width = widthObject instanceof Integer ? (Integer)widthObject : 0;
            if (width < javafxPanel.getWidth()) {
                width = javafxPanel.getWidth();
            }
            if (height <= 0 || width <= 0) {
                return;
            }
            int count = IpnbJfxUtils.countNewLinesInMath(source);
            Dimension size = new Dimension(width, height + count * EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize());
            ApplicationManager.getApplication().invokeLater(() -> {
                javafxPanel.setPreferredSize(size);
                javafxPanel.revalidate();
                javafxPanel.repaint();
            });
        }
    }

    private static int countNewLinesInMath(String source) {
        int count = 0;
        if (source.contains("```")) {
            ++count;
        }
        boolean inMath = false;
        if (source.contains("\\frac")) {
            ++count;
        }
        if (source.contains("\\limits")) {
            count += 2;
        }
        while (source.contains("$$")) {
            if (inMath) {
                String substring = source.substring(0, source.indexOf("$$") + 2);
                count += StringUtil.countNewLines((CharSequence)substring);
                int len = substring.length();
                for (int i = 0; i < len; ++i) {
                    if (substring.charAt(i) != '\\' || i + 1 >= substring.length() || substring.charAt(i + 1) != '\\') continue;
                    ++count;
                    ++i;
                }
            }
            inMath = !inMath;
            source = source.substring(source.indexOf("$$") + 2);
        }
        return count;
    }

    private static void updateLaf(boolean isDarcula, WebEngine engine, JFXPanel jfxPanel) {
        if (isDarcula) {
            IpnbJfxUtils.updateLafDarcula(engine, jfxPanel);
        }
    }

    private static void updateLafDarcula(WebEngine engine, JFXPanel jfxPanel) {
        ApplicationManager.getApplication().invokeLater(() -> IpnbJfxUtils.runFX(() -> Platform.runLater(() -> {
            ourStyleUrl = IpnbFileType.class.getResource("/style/javaFXBrowserDarcula.css");
            engine.setUserStyleSheetLocation(ourStyleUrl.toExternalForm());
            jfxPanel.getScene().getStylesheets().add((Object)ourStyleUrl.toExternalForm());
            engine.reload();
        })));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ipnb/IpnbJfxUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ipnb/IpnbJfxUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapMath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runFX";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlPanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertToHtml";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unwrapMath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "wrapMath";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initHyperlinkListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HyperlinkListener
    implements EventListener {
        @NotNull
        private final WebEngine myEngine;

        HyperlinkListener(@NotNull WebEngine engine) {
            if (engine == null) {
                HyperlinkListener.$$$reportNull$$$0(0);
            }
            this.myEngine = engine;
        }

        @Override
        public void handleEvent(Event ev) {
            String domEventType = ev.getType();
            if (domEventType.equals("click")) {
                this.myEngine.setJavaScriptEnabled(true);
                this.myEngine.getLoadWorker().cancel();
                ev.preventDefault();
                UIUtil.invokeLaterIfNeeded(() -> {
                    String href = ((Element)((Object)ev.getTarget())).getAttribute("href");
                    if (href == null) {
                        return;
                    }
                    try {
                        URI address = new URI(href);
                        BrowserUtil.browse((URI)address);
                    }
                    catch (URISyntaxException e) {
                        LOG.warn(e.getMessage());
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "org/jetbrains/plugins/ipnb/IpnbJfxUtils$HyperlinkListener", "<init>"));
        }
    }
}

