/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.linearBek.LinearBekGraph;
import com.intellij.vcs.log.graph.utils.IntIntMultiMap;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LinearBekGraphBuilder {
    private static final int MAX_BLOCK_SIZE = 200;
    private static final int MAGIC_SET_SIZE = 30;
    private static final GraphEdgeToDownNode GRAPH_EDGE_TO_DOWN_NODE = new GraphEdgeToDownNode();
    @NotNull
    private final GraphLayout myGraphLayout;
    private final LinearBekGraph myLinearBekGraph;

    LinearBekGraphBuilder(@NotNull LinearBekGraph bekGraph, @NotNull GraphLayout graphLayout) {
        if (bekGraph == null) {
            LinearBekGraphBuilder.$$$reportNull$$$0(0);
        }
        if (graphLayout == null) {
            LinearBekGraphBuilder.$$$reportNull$$$0(1);
        }
        this.myLinearBekGraph = bekGraph;
        this.myGraphLayout = graphLayout;
    }

    public void collapseAll() {
        for (int i = this.myLinearBekGraph.myGraph.nodesCount() - 1; i >= 0; --i) {
            MergeFragment fragment = this.getFragment(i);
            if (fragment == null) continue;
            fragment.collapse(this.myLinearBekGraph);
        }
    }

    @Nullable
    public MergeFragment collapseFragment(int mergeCommit) {
        MergeFragment fragment = this.getFragment(mergeCommit);
        if (fragment != null) {
            fragment.collapse(this.myLinearBekGraph);
            return fragment;
        }
        return null;
    }

    @Nullable
    public MergeFragment getFragment(int mergeCommit) {
        List downNodes = ContainerUtil.sorted(LinearGraphUtils.getDownNodes(this.myLinearBekGraph, mergeCommit));
        if (downNodes.size() != 2) {
            return null;
        }
        return this.getFragment((Integer)downNodes.get(1), (Integer)downNodes.get(0), mergeCommit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private MergeFragment getFragment(int leftChild, int rightChild, int parent) {
        MergeFragment fragment = new MergeFragment(parent, leftChild, rightChild);
        int leftLi = this.myGraphLayout.getLayoutIndex(leftChild);
        int rightLi = this.myGraphLayout.getLayoutIndex(rightChild);
        int rowsCount = 1;
        int blockSize = 1;
        PriorityQueue<GraphEdge> queue2 = new PriorityQueue<GraphEdge>(200, new GraphEdgeComparator());
        queue2.addAll(this.myLinearBekGraph.getAdjacentEdges(rightChild, EdgeFilter.NORMAL_DOWN));
        Set<Integer> magicSet = null;
        while (!queue2.isEmpty()) {
            GraphEdge nextEdge = queue2.poll();
            Integer next = nextEdge.getDownNodeIndex();
            Integer upNodeIndex = nextEdge.getUpNodeIndex();
            assert (upNodeIndex != null);
            if (next == null) {
                fragment.addTail(upNodeIndex);
                continue;
            }
            if (next == leftChild) {
                fragment.addTail(upNodeIndex);
                fragment.setMergeWithOldCommit(true);
            } else if (next == rightChild + rowsCount) {
                ++rowsCount;
                ++blockSize;
                queue2.addAll(this.myLinearBekGraph.getAdjacentEdges(next, EdgeFilter.NORMAL_DOWN));
                fragment.addBody(upNodeIndex);
            } else if (next > rightChild + rowsCount && next < leftChild) {
                rowsCount = next - rightChild + 1;
                ++blockSize;
                queue2.addAll(this.myLinearBekGraph.getAdjacentEdges(next, EdgeFilter.NORMAL_DOWN));
                fragment.addBody(upNodeIndex);
            } else if (next > leftChild) {
                int li = this.myGraphLayout.getLayoutIndex(next);
                if (leftLi > rightLi && !fragment.isMergeWithOldCommit()) {
                    if (next > leftChild + 30) {
                        return null;
                    }
                    if (magicSet == null) {
                        magicSet = this.calculateMagicSet(leftChild);
                    }
                    if (!magicSet.contains(next)) return null;
                    fragment.addTailEdge(upNodeIndex, next);
                } else if (li > leftLi && li < rightLi || li == leftLi) {
                    fragment.addTailEdge(upNodeIndex, next);
                } else {
                    if (li >= rightLi) {
                        return null;
                    }
                    if (next > leftChild + 30) {
                        if (!fragment.hasTailEdge(upNodeIndex) && !fragment.isBody(upNodeIndex)) {
                            return null;
                        }
                    } else {
                        if (magicSet == null) {
                            magicSet = this.calculateMagicSet(leftChild);
                        }
                        if (!magicSet.contains(next)) return null;
                        fragment.addTailEdge(upNodeIndex, next);
                    }
                }
            }
            if (blockSize < 200) continue;
            return null;
        }
        if (!fragment.getTails().isEmpty()) return fragment;
        return null;
    }

    @NotNull
    private Set<Integer> calculateMagicSet(int node) {
        Integer i;
        HashSet magicSet = ContainerUtil.newHashSet((int)30);
        PriorityQueue magicQueue = new PriorityQueue(30);
        magicQueue.addAll(ContainerUtil.map(this.myLinearBekGraph.getAdjacentEdges(node, EdgeFilter.NORMAL_DOWN), (Function)GRAPH_EDGE_TO_DOWN_NODE));
        while (!magicQueue.isEmpty() && (i = (Integer)magicQueue.poll()) <= node + 30) {
            magicSet.add(i);
            magicQueue.addAll(ContainerUtil.map(this.myLinearBekGraph.getAdjacentEdges(i, EdgeFilter.NORMAL_DOWN), (Function)GRAPH_EDGE_TO_DOWN_NODE));
        }
        HashSet hashSet = magicSet;
        if (hashSet == null) {
            LinearBekGraphBuilder.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bekGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphLayout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMagicSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GraphEdgeToDownNode
    implements Function<GraphEdge, Integer> {
        private GraphEdgeToDownNode() {
        }

        public Integer fun(GraphEdge graphEdge) {
            return graphEdge.getDownNodeIndex();
        }
    }

    private static class GraphEdgeComparator
    implements Comparator<GraphEdge> {
        private GraphEdgeComparator() {
        }

        @Override
        public int compare(@NotNull GraphEdge e1, @NotNull GraphEdge e2) {
            if (e1 == null) {
                GraphEdgeComparator.$$$reportNull$$$0(0);
            }
            if (e2 == null) {
                GraphEdgeComparator.$$$reportNull$$$0(1);
            }
            Integer d1 = e1.getDownNodeIndex();
            Integer d2 = e2.getDownNodeIndex();
            if (d1 == null) {
                if (d2 == null) {
                    return e1.hashCode() - e2.hashCode();
                }
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            return d1.compareTo(d2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder$GraphEdgeComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MergeFragment {
        private final int myParent;
        private final int myLeftChild;
        private final int myRightChild;
        private boolean myMergeWithOldCommit = false;
        @NotNull
        private final IntIntMultiMap myTailEdges = new IntIntMultiMap();
        @NotNull
        private final TIntHashSet myBlockBody = new TIntHashSet();
        @NotNull
        private final TIntHashSet myTails = new TIntHashSet();

        private MergeFragment(int parent, int leftChild, int rightChild) {
            this.myParent = parent;
            this.myLeftChild = leftChild;
            this.myRightChild = rightChild;
        }

        public boolean isMergeWithOldCommit() {
            return this.myMergeWithOldCommit;
        }

        public void setMergeWithOldCommit(boolean mergeWithOldCommit) {
            this.myMergeWithOldCommit = mergeWithOldCommit;
        }

        public void addTail(int tail) {
            if (!this.myBlockBody.contains(tail)) {
                this.myTails.add(tail);
            }
        }

        public void addTailEdge(int upNodeIndex, int downNodeIndex) {
            if (!this.myBlockBody.contains(upNodeIndex)) {
                this.myTails.add(upNodeIndex);
                this.myTailEdges.putValue(upNodeIndex, downNodeIndex);
            }
        }

        public void addBody(int body) {
            this.myBlockBody.add(body);
        }

        @NotNull
        public TIntHashSet getTails() {
            TIntHashSet tIntHashSet = this.myTails;
            if (tIntHashSet == null) {
                MergeFragment.$$$reportNull$$$0(0);
            }
            return tIntHashSet;
        }

        public Set<Integer> getTailsAndBody() {
            HashSet nodes = ContainerUtil.newHashSet();
            TIntIterator it = this.myBlockBody.iterator();
            while (it.hasNext()) {
                nodes.add(it.next());
            }
            it = this.myTails.iterator();
            while (it.hasNext()) {
                nodes.add(it.next());
            }
            return nodes;
        }

        public Set<Integer> getAllNodes() {
            HashSet nodes = ContainerUtil.newHashSet();
            nodes.add(this.myParent);
            nodes.add(this.myLeftChild);
            nodes.add(this.myRightChild);
            nodes.addAll(this.getTailsAndBody());
            return nodes;
        }

        public void collapse(LinearBekGraph graph2) {
            for (int upNodeIndex : this.myTailEdges.keys()) {
                for (int downNodeIndex : this.myTailEdges.get(upNodeIndex)) {
                    MergeFragment.removeEdge(graph2, upNodeIndex, downNodeIndex);
                }
            }
            for (int tail : this.myTails) {
                if (!LinearGraphUtils.getDownNodes(graph2, tail).contains(this.myLeftChild)) {
                    MergeFragment.addEdge(graph2, tail, this.myLeftChild);
                    continue;
                }
                MergeFragment.replaceEdge(graph2, tail, this.myLeftChild);
            }
            MergeFragment.removeEdge(graph2, this.myParent, this.myLeftChild);
        }

        private static void addEdge(LinearBekGraph graph2, int up, int down) {
            graph2.myDottedEdges.createEdge(new GraphEdge(up, down, null, GraphEdgeType.DOTTED));
        }

        private static void removeEdge(LinearBekGraph graph2, int up, int down) {
            if (graph2.myDottedEdges.hasEdge(up, down)) {
                graph2.myDottedEdges.removeEdge(new GraphEdge(up, down, null, GraphEdgeType.DOTTED));
                graph2.myHiddenEdges.createEdge(new GraphEdge(up, down, null, GraphEdgeType.DOTTED));
            } else {
                GraphEdge edge = LinearGraphUtils.getEdge(graph2.myGraph, up, down);
                assert (edge != null) : "No edge between " + up + " and " + down;
                graph2.myHiddenEdges.createEdge(edge);
            }
        }

        private static void replaceEdge(LinearBekGraph graph2, int up, int down) {
            if (!graph2.myDottedEdges.hasEdge(up, down)) {
                GraphEdge edge = LinearGraphUtils.getEdge(graph2.myGraph, up, down);
                assert (edge != null) : "No edge between " + up + " and " + down;
                graph2.myHiddenEdges.createEdge(edge);
                graph2.myDottedEdges.createEdge(new GraphEdge(up, down, null, GraphEdgeType.DOTTED));
            }
        }

        public int getParent() {
            return this.myParent;
        }

        public boolean hasTailEdge(Integer index) {
            return !this.myTailEdges.get(index).isEmpty();
        }

        public boolean isBody(Integer index) {
            return this.myBlockBody.contains(index.intValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/linearBek/LinearBekGraphBuilder$MergeFragment", "getTails"));
        }
    }
}

