/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.net.Socket;
import java.security.AlgorithmConstraints;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import sun.security.ssl.Debug;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.util.HostnameChecker;
import sun.security.validator.Validator;

final class X509TrustManagerImpl
extends X509ExtendedTrustManager
implements X509TrustManager {
    private final String validatorType;
    private final Collection<X509Certificate> trustedCerts;
    private final PKIXBuilderParameters pkixParams;
    private volatile Validator clientValidator;
    private volatile Validator serverValidator;
    private static final Debug debug = Debug.getInstance("ssl");

    X509TrustManagerImpl(String string, Collection<X509Certificate> collection) {
        this.validatorType = string;
        this.pkixParams = null;
        if (collection == null) {
            collection = Collections.emptySet();
        }
        this.trustedCerts = collection;
        if (debug != null && Debug.isOn("trustmanager")) {
            this.showTrustedCerts();
        }
    }

    X509TrustManagerImpl(String string, PKIXBuilderParameters pKIXBuilderParameters) {
        this.validatorType = string;
        this.pkixParams = pKIXBuilderParameters;
        Validator validator = this.getValidator("tls server");
        this.trustedCerts = validator.getTrustedCertificates();
        this.serverValidator = validator;
        if (debug != null && Debug.isOn("trustmanager")) {
            this.showTrustedCerts();
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, (Socket)null, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, (Socket)null, false);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.trustedCerts.size()];
        this.trustedCerts.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, socket, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, socket, false);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, sSLEngine, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine) throws CertificateException {
        this.checkTrusted(x509CertificateArray, string, sSLEngine, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Validator checkTrustedInit(X509Certificate[] x509CertificateArray, String string, boolean bl) {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            throw new IllegalArgumentException("null or zero-length certificate chain");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("null or zero-length authentication type");
        }
        Validator validator = null;
        if (bl) {
            validator = this.clientValidator;
            if (validator == null) {
                X509TrustManagerImpl x509TrustManagerImpl = this;
                synchronized (x509TrustManagerImpl) {
                    validator = this.clientValidator;
                    if (validator == null) {
                        this.clientValidator = validator = this.getValidator("tls client");
                    }
                }
            }
        } else {
            validator = this.serverValidator;
            if (validator == null) {
                X509TrustManagerImpl x509TrustManagerImpl = this;
                synchronized (x509TrustManagerImpl) {
                    validator = this.serverValidator;
                    if (validator == null) {
                        this.serverValidator = validator = this.getValidator("tls server");
                    }
                }
            }
        }
        return validator;
    }

    private void checkTrusted(X509Certificate[] x509CertificateArray, String string, Socket socket, boolean bl) throws CertificateException {
        X509Certificate[] x509CertificateArray2;
        Validator validator = this.checkTrustedInit(x509CertificateArray, string, bl);
        SSLAlgorithmConstraints sSLAlgorithmConstraints = null;
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket) {
            x509CertificateArray2 = (X509Certificate[])socket;
            SSLSession sSLSession = x509CertificateArray2.getHandshakeSession();
            if (sSLSession == null) {
                throw new CertificateException("No handshake session");
            }
            String string2 = x509CertificateArray2.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (string2 != null && string2.length() != 0) {
                X509TrustManagerImpl.checkIdentity(sSLSession, x509CertificateArray[0], string2, bl, X509TrustManagerImpl.getRequestedServerNames(socket));
            }
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(sSLSession.getProtocol());
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                if (sSLSession instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)sSLSession;
                    String[] stringArray = extendedSSLSession.getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints((SSLSocket)x509CertificateArray2, stringArray, false);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints((SSLSocket)x509CertificateArray2, false);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints((SSLSocket)x509CertificateArray2, false);
            }
        }
        x509CertificateArray2 = null;
        x509CertificateArray2 = bl ? X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, null) : X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, string);
        if (debug != null && Debug.isOn("trustmanager")) {
            System.out.println("Found trusted certificate:");
            System.out.println(x509CertificateArray2[x509CertificateArray2.length - 1]);
        }
    }

    private void checkTrusted(X509Certificate[] x509CertificateArray, String string, SSLEngine sSLEngine, boolean bl) throws CertificateException {
        X509Certificate[] x509CertificateArray2;
        Validator validator = this.checkTrustedInit(x509CertificateArray, string, bl);
        SSLAlgorithmConstraints sSLAlgorithmConstraints = null;
        if (sSLEngine != null) {
            x509CertificateArray2 = sSLEngine.getHandshakeSession();
            if (x509CertificateArray2 == null) {
                throw new CertificateException("No handshake session");
            }
            String string2 = sSLEngine.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (string2 != null && string2.length() != 0) {
                X509TrustManagerImpl.checkIdentity((SSLSession)x509CertificateArray2, x509CertificateArray[0], string2, bl, X509TrustManagerImpl.getRequestedServerNames(sSLEngine));
            }
            ProtocolVersion protocolVersion = ProtocolVersion.valueOf(x509CertificateArray2.getProtocol());
            if (protocolVersion.v >= ProtocolVersion.TLS12.v) {
                if (x509CertificateArray2 instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)x509CertificateArray2;
                    String[] stringArray = extendedSSLSession.getLocalSupportedSignatureAlgorithms();
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, stringArray, false);
                } else {
                    sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, false);
                }
            } else {
                sSLAlgorithmConstraints = new SSLAlgorithmConstraints(sSLEngine, false);
            }
        }
        x509CertificateArray2 = null;
        x509CertificateArray2 = bl ? X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, null) : X509TrustManagerImpl.validate(validator, x509CertificateArray, sSLAlgorithmConstraints, string);
        if (debug != null && Debug.isOn("trustmanager")) {
            System.out.println("Found trusted certificate:");
            System.out.println(x509CertificateArray2[x509CertificateArray2.length - 1]);
        }
    }

    private void showTrustedCerts() {
        for (X509Certificate x509Certificate : this.trustedCerts) {
            System.out.println("adding as trusted cert:");
            System.out.println("  Subject: " + x509Certificate.getSubjectX500Principal());
            System.out.println("  Issuer:  " + x509Certificate.getIssuerX500Principal());
            System.out.println("  Algorithm: " + x509Certificate.getPublicKey().getAlgorithm() + "; Serial number: 0x" + x509Certificate.getSerialNumber().toString(16));
            System.out.println("  Valid from " + x509Certificate.getNotBefore() + " until " + x509Certificate.getNotAfter());
            System.out.println();
        }
    }

    private Validator getValidator(String string) {
        Validator validator = this.pkixParams == null ? Validator.getInstance(this.validatorType, string, this.trustedCerts) : Validator.getInstance(this.validatorType, string, this.pkixParams);
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] validate(Validator validator, X509Certificate[] x509CertificateArray, AlgorithmConstraints algorithmConstraints, String string) throws CertificateException {
        Object object = JsseJce.beginFipsProvider();
        try {
            X509Certificate[] x509CertificateArray2 = validator.validate(x509CertificateArray, null, algorithmConstraints, string);
            return x509CertificateArray2;
        }
        finally {
            JsseJce.endFipsProvider(object);
        }
    }

    private static String getHostNameInSNI(List<SNIServerName> list) {
        SNIHostName sNIHostName = null;
        for (SNIServerName sNIServerName : list) {
            if (sNIServerName.getType() != 0) continue;
            if (sNIServerName instanceof SNIHostName) {
                sNIHostName = (SNIHostName)sNIServerName;
                break;
            }
            try {
                sNIHostName = new SNIHostName(sNIServerName.getEncoded());
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (debug == null || !Debug.isOn("trustmanager")) break;
                System.out.println("Illegal server name: " + sNIServerName);
                break;
            }
        }
        if (sNIHostName != null) {
            return sNIHostName.getAsciiName();
        }
        return null;
    }

    static List<SNIServerName> getRequestedServerNames(Socket socket) {
        SSLSocket sSLSocket;
        SSLSession sSLSession;
        if (socket != null && socket.isConnected() && socket instanceof SSLSocket && (sSLSession = (sSLSocket = (SSLSocket)socket).getHandshakeSession()) != null && sSLSession instanceof ExtendedSSLSession) {
            ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)sSLSession;
            return extendedSSLSession.getRequestedServerNames();
        }
        return Collections.emptyList();
    }

    static List<SNIServerName> getRequestedServerNames(SSLEngine sSLEngine) {
        SSLSession sSLSession;
        if (sSLEngine != null && (sSLSession = sSLEngine.getHandshakeSession()) != null && sSLSession instanceof ExtendedSSLSession) {
            ExtendedSSLSession extendedSSLSession = (ExtendedSSLSession)sSLSession;
            return extendedSSLSession.getRequestedServerNames();
        }
        return Collections.emptyList();
    }

    private static void checkIdentity(SSLSession sSLSession, X509Certificate x509Certificate, String string, boolean bl, List<SNIServerName> list) throws CertificateException {
        String string2;
        boolean bl2;
        block4: {
            String string3;
            bl2 = false;
            string2 = sSLSession.getPeerHost();
            if (bl && (string3 = X509TrustManagerImpl.getHostNameInSNI(list)) != null) {
                try {
                    X509TrustManagerImpl.checkIdentity(string3, x509Certificate, string);
                    bl2 = true;
                }
                catch (CertificateException certificateException) {
                    if (!string3.equalsIgnoreCase(string2)) break block4;
                    throw certificateException;
                }
            }
        }
        if (!bl2) {
            X509TrustManagerImpl.checkIdentity(string2, x509Certificate, string);
        }
    }

    static void checkIdentity(String string, X509Certificate x509Certificate, String string2) throws CertificateException {
        if (string2 != null && string2.length() != 0) {
            if (string != null && string.startsWith("[") && string.endsWith("]")) {
                string = string.substring(1, string.length() - 1);
            }
            if (string2.equalsIgnoreCase("HTTPS")) {
                HostnameChecker.getInstance((byte)1).match(string, x509Certificate);
            } else if (string2.equalsIgnoreCase("LDAP") || string2.equalsIgnoreCase("LDAPS")) {
                HostnameChecker.getInstance((byte)2).match(string, x509Certificate);
            } else {
                throw new CertificateException("Unknown identification algorithm: " + string2);
            }
        }
    }
}

