/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class PolylineController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView polylineView;
    private Float thickness;
    private boolean capStyleEditable;
    private Polyline.CapStyle capStyle;
    private Polyline.JoinStyle joinStyle;
    private boolean joinStyleEditable;
    private Polyline.DashStyle dashStyle;
    private float[] dashPattern;
    private Float dashOffset;
    private boolean arrowsStyleEditable;
    private Polyline.ArrowStyle startArrowStyle;
    private Polyline.ArrowStyle endArrowStyle;
    private Integer color;
    private Float elevation;
    private Boolean elevationEnabled;

    public PolylineController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    @Override
    public DialogView getView() {
        if (this.polylineView == null) {
            this.polylineView = this.viewFactory.createPolylineView(this.preferences, this);
        }
        return this.polylineView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        List<Polyline> list = Home.getPolylinesSubList(this.home.getSelectedItems());
        if (list.isEmpty()) {
            this.setThickness(null);
            this.capStyleEditable = false;
            this.setCapStyle(null);
            this.joinStyleEditable = false;
            this.setJoinStyle(null);
            this.setDashStyle(null);
            this.dashPattern = null;
            this.setDashOffset(null);
            this.arrowsStyleEditable = false;
            this.setStartArrowStyle(null);
            this.setEndArrowStyle(null);
            this.setColor(null);
            this.elevationEnabled = Boolean.FALSE;
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            Polyline polyline = list.get(0);
            Float f = Float.valueOf(polyline.getThickness());
            for (n4 = 1; n4 < list.size(); ++n4) {
                if (f.floatValue() == list.get(n4).getThickness()) continue;
                f = null;
                break;
            }
            this.setThickness(f);
            this.capStyleEditable = false;
            for (n4 = 0; n4 < list.size(); ++n4) {
                if (list.get(n4).isClosedPath()) continue;
                this.capStyleEditable = true;
                break;
            }
            if (this.capStyleEditable) {
                Polyline.CapStyle capStyle = polyline.getCapStyle();
                if (capStyle != null) {
                    for (n3 = 1; n3 < list.size(); ++n3) {
                        if (capStyle == list.get(n3).getCapStyle()) continue;
                        capStyle = null;
                        break;
                    }
                }
                this.setCapStyle(capStyle);
            } else {
                this.setCapStyle(null);
            }
            this.joinStyleEditable = false;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).getPointCount() <= 2) continue;
                this.joinStyleEditable = true;
                break;
            }
            if (this.joinStyleEditable) {
                Polyline.JoinStyle joinStyle = polyline.getJoinStyle();
                if (joinStyle != null) {
                    for (n3 = 1; n3 < list.size(); ++n3) {
                        if (joinStyle == list.get(n3).getJoinStyle()) continue;
                        joinStyle = null;
                        break;
                    }
                }
                this.setJoinStyle(joinStyle);
            } else {
                this.setJoinStyle(null);
            }
            float[] fArray = polyline.getDashPattern();
            if (fArray != null) {
                for (n3 = 1; n3 < list.size(); ++n3) {
                    if (Arrays.equals(fArray, list.get(n3).getDashPattern())) continue;
                    fArray = null;
                    break;
                }
            }
            this.setDashPattern(fArray);
            if (fArray != null) {
                Polyline.DashStyle dashStyle = polyline.getDashStyle();
                if (dashStyle != null) {
                    for (n2 = 1; n2 < list.size(); ++n2) {
                        if (dashStyle == list.get(n2).getDashStyle()) continue;
                        dashStyle = null;
                        break;
                    }
                }
                if (dashStyle == Polyline.DashStyle.CUSTOMIZED) {
                    // empty if block
                }
                this.setDashStyle(dashStyle);
            } else {
                this.setDashStyle(null);
            }
            Float f2 = Float.valueOf(polyline.getDashOffset());
            for (n2 = 1; n2 < list.size(); ++n2) {
                if (f2.floatValue() == list.get(n2).getDashOffset()) continue;
                f2 = null;
                break;
            }
            this.setDashOffset(f2);
            this.arrowsStyleEditable = this.capStyleEditable;
            if (this.arrowsStyleEditable) {
                Polyline.ArrowStyle arrowStyle = polyline.getStartArrowStyle();
                if (arrowStyle != null) {
                    for (int i = 1; i < list.size(); ++i) {
                        if (arrowStyle == list.get(i).getStartArrowStyle()) continue;
                        arrowStyle = null;
                        break;
                    }
                }
                this.setStartArrowStyle(arrowStyle);
                Polyline.ArrowStyle arrowStyle2 = polyline.getEndArrowStyle();
                if (arrowStyle2 != null) {
                    for (n = 1; n < list.size(); ++n) {
                        if (arrowStyle2 == list.get(n).getEndArrowStyle()) continue;
                        arrowStyle2 = null;
                        break;
                    }
                }
                this.setEndArrowStyle(arrowStyle2);
            } else {
                this.setStartArrowStyle(null);
                this.setEndArrowStyle(null);
            }
            Integer n5 = polyline.getColor();
            if (n5 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (n5.intValue() == list.get(i).getColor()) continue;
                    n5 = null;
                    break;
                }
            }
            this.setColor(n5);
            Float f3 = Float.valueOf(polyline.getElevation());
            for (n = 1; n < list.size(); ++n) {
                if (f3.floatValue() == list.get(n).getElevation()) continue;
                f3 = null;
                break;
            }
            this.setElevation(f3);
            Boolean bl = polyline.isVisibleIn3D();
            for (int i = 1; i < list.size(); ++i) {
                if (bl.equals(list.get(i).isVisibleIn3D())) continue;
                bl = null;
                break;
            }
            this.elevationEnabled = bl;
        }
    }

    public void setThickness(Float f) {
        if (f != this.thickness) {
            Float f2 = this.thickness;
            this.thickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.THICKNESS.name(), f2, f);
        }
    }

    public Float getThickness() {
        return this.thickness;
    }

    public void setCapStyle(Polyline.CapStyle capStyle) {
        if (capStyle != this.capStyle) {
            Polyline.CapStyle capStyle2 = this.capStyle;
            this.capStyle = capStyle;
            this.propertyChangeSupport.firePropertyChange(Property.CAP_STYLE.name(), (Object)capStyle2, (Object)capStyle);
        }
    }

    public Polyline.CapStyle getCapStyle() {
        return this.capStyle;
    }

    public boolean isCapStyleEditable() {
        return this.capStyleEditable;
    }

    public void setJoinStyle(Polyline.JoinStyle joinStyle) {
        if (joinStyle != this.joinStyle) {
            Polyline.JoinStyle joinStyle2 = this.joinStyle;
            this.joinStyle = joinStyle;
            this.propertyChangeSupport.firePropertyChange(Property.JOIN_STYLE.name(), (Object)joinStyle2, (Object)joinStyle);
        }
    }

    public Polyline.JoinStyle getJoinStyle() {
        return this.joinStyle;
    }

    public boolean isJoinStyleEditable() {
        return this.joinStyleEditable;
    }

    public void setDashStyle(Polyline.DashStyle dashStyle) {
        if (dashStyle != this.dashStyle) {
            Polyline.DashStyle dashStyle2 = this.dashStyle;
            this.dashStyle = dashStyle;
            this.propertyChangeSupport.firePropertyChange(Property.DASH_STYLE.name(), (Object)dashStyle2, (Object)dashStyle);
        }
    }

    public Polyline.DashStyle getDashStyle() {
        return this.dashStyle;
    }

    public void setDashPattern(float[] fArray) {
        if (!Arrays.equals(fArray, this.dashPattern)) {
            float[] fArray2 = this.dashPattern;
            this.dashPattern = fArray;
            this.propertyChangeSupport.firePropertyChange(Property.DASH_PATTERN.name(), fArray2, fArray);
        }
    }

    public float[] getDashPattern() {
        return this.dashPattern;
    }

    public void setDashOffset(Float f) {
        if (f != this.dashOffset) {
            Float f2 = this.dashOffset;
            this.dashOffset = f;
            this.propertyChangeSupport.firePropertyChange(Property.DASH_OFFSET.name(), f2, f);
        }
    }

    public Float getDashOffset() {
        return this.dashOffset;
    }

    public void setStartArrowStyle(Polyline.ArrowStyle arrowStyle) {
        if (arrowStyle != this.startArrowStyle) {
            Polyline.ArrowStyle arrowStyle2 = this.startArrowStyle;
            this.startArrowStyle = arrowStyle;
            this.propertyChangeSupport.firePropertyChange(Property.START_ARROW_STYLE.name(), (Object)arrowStyle2, (Object)arrowStyle);
        }
    }

    public Polyline.ArrowStyle getStartArrowStyle() {
        return this.startArrowStyle;
    }

    public void setEndArrowStyle(Polyline.ArrowStyle arrowStyle) {
        if (arrowStyle != this.endArrowStyle) {
            Polyline.ArrowStyle arrowStyle2 = this.endArrowStyle;
            this.endArrowStyle = arrowStyle;
            this.propertyChangeSupport.firePropertyChange(Property.END_ARROW_STYLE.name(), (Object)arrowStyle2, (Object)arrowStyle);
        }
    }

    public Polyline.ArrowStyle getEndArrowStyle() {
        return this.endArrowStyle;
    }

    public boolean isArrowsStyleEditable() {
        return this.arrowsStyleEditable;
    }

    public void setColor(Integer n) {
        if (n != this.color) {
            Integer n2 = this.color;
            this.color = n;
            this.propertyChangeSupport.firePropertyChange(Property.COLOR.name(), n2, n);
        }
    }

    public Integer getColor() {
        return this.color;
    }

    public void setElevation(Float f) {
        if (f != this.elevation) {
            Float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), f2, f);
        }
        this.elevationEnabled = f != null;
    }

    public Float getElevation() {
        return this.elevation;
    }

    public Boolean isElevationEnabled() {
        return this.elevationEnabled;
    }

    public void modifyPolylines() {
        List<Selectable> list = this.home.getSelectedItems();
        List<Polyline> list2 = Home.getPolylinesSubList(list);
        if (!list2.isEmpty()) {
            Float f = this.getThickness();
            Polyline.CapStyle capStyle = this.getCapStyle();
            Polyline.JoinStyle joinStyle = this.getJoinStyle();
            Polyline.DashStyle dashStyle = this.getDashStyle();
            float[] fArray = this.getDashPattern();
            Float f2 = this.getDashOffset();
            Polyline.ArrowStyle arrowStyle = this.getStartArrowStyle();
            Polyline.ArrowStyle arrowStyle2 = this.getEndArrowStyle();
            Integer n = this.getColor();
            Float f3 = this.getElevation();
            Boolean bl = this.isElevationEnabled();
            ModifiedPolyline[] modifiedPolylineArray = new ModifiedPolyline[list2.size()];
            for (int i = 0; i < modifiedPolylineArray.length; ++i) {
                modifiedPolylineArray[i] = new ModifiedPolyline(list2.get(i));
            }
            PolylineController.doModifyPolylines(modifiedPolylineArray, f, capStyle, joinStyle, dashStyle, fArray, f2, arrowStyle, arrowStyle2, n, f3, bl);
            if (this.undoSupport != null) {
                PolylinesModificationUndoableEdit polylinesModificationUndoableEdit = new PolylinesModificationUndoableEdit(this.home, this.preferences, list, modifiedPolylineArray, f, capStyle, joinStyle, dashStyle, fArray, f2, arrowStyle, arrowStyle2, n, f3, bl);
                this.undoSupport.postEdit(polylinesModificationUndoableEdit);
            }
        }
    }

    private static void doModifyPolylines(ModifiedPolyline[] modifiedPolylineArray, Float f, Polyline.CapStyle capStyle, Polyline.JoinStyle joinStyle, Polyline.DashStyle dashStyle, float[] fArray, Float f2, Polyline.ArrowStyle arrowStyle, Polyline.ArrowStyle arrowStyle2, Integer n, Float f3, Boolean bl) {
        for (ModifiedPolyline modifiedPolyline : modifiedPolylineArray) {
            Polyline polyline = modifiedPolyline.getPolyline();
            if (f != null) {
                polyline.setThickness(f.floatValue());
            }
            if (capStyle != null) {
                polyline.setCapStyle(capStyle);
            }
            if (joinStyle != null) {
                polyline.setJoinStyle(joinStyle);
            }
            if (dashStyle != null) {
                polyline.setDashStyle(dashStyle);
            }
            if (dashStyle == Polyline.DashStyle.CUSTOMIZED && fArray != null) {
                polyline.setDashPattern(fArray);
            }
            if (f2 != null) {
                polyline.setDashOffset(polyline.getDashStyle() != Polyline.DashStyle.SOLID ? f2.floatValue() : 0.0f);
            }
            if (arrowStyle != null) {
                polyline.setStartArrowStyle(arrowStyle);
            }
            if (arrowStyle2 != null) {
                polyline.setEndArrowStyle(arrowStyle2);
            }
            if (n != null) {
                polyline.setColor(n);
            }
            if (bl == null) continue;
            if (Boolean.FALSE.equals(bl)) {
                polyline.setVisibleIn3D(false);
                continue;
            }
            if (f3 == null) continue;
            polyline.setVisibleIn3D(true);
            polyline.setElevation(f3.floatValue());
        }
    }

    private static void undoModifyPolylines(ModifiedPolyline[] modifiedPolylineArray) {
        for (ModifiedPolyline modifiedPolyline : modifiedPolylineArray) {
            modifiedPolyline.reset();
        }
    }

    private static final class ModifiedPolyline {
        private final Polyline polyline;
        private final float thickness;
        private final Polyline.CapStyle capStyle;
        private final Polyline.JoinStyle joinStyle;
        private final float[] dashPattern;
        private final Float dashOffset;
        private final Polyline.ArrowStyle startArrowStyle;
        private final Polyline.ArrowStyle endArrowStyle;
        private final int color;
        private final boolean visibleIn3D;
        private final float elevation;

        public ModifiedPolyline(Polyline polyline) {
            this.polyline = polyline;
            this.thickness = polyline.getThickness();
            this.capStyle = polyline.getCapStyle();
            this.joinStyle = polyline.getJoinStyle();
            this.dashPattern = polyline.getDashPattern();
            this.dashOffset = Float.valueOf(polyline.getDashOffset());
            this.startArrowStyle = polyline.getStartArrowStyle();
            this.endArrowStyle = polyline.getEndArrowStyle();
            this.color = polyline.getColor();
            this.visibleIn3D = polyline.isVisibleIn3D();
            this.elevation = polyline.getElevation();
        }

        public Polyline getPolyline() {
            return this.polyline;
        }

        public void reset() {
            this.polyline.setThickness(this.thickness);
            this.polyline.setCapStyle(this.capStyle);
            this.polyline.setJoinStyle(this.joinStyle);
            this.polyline.setDashPattern(this.dashPattern);
            this.polyline.setDashOffset(this.dashOffset.floatValue());
            this.polyline.setStartArrowStyle(this.startArrowStyle);
            this.polyline.setEndArrowStyle(this.endArrowStyle);
            this.polyline.setColor(this.color);
            this.polyline.setVisibleIn3D(this.visibleIn3D);
            this.polyline.setElevation(this.elevation);
        }
    }

    private static class PolylinesModificationUndoableEdit
    extends AbstractUndoableEdit {
        private final Home home;
        private final UserPreferences preferences;
        private final List<Selectable> oldSelection;
        private final ModifiedPolyline[] modifiedPolylines;
        private Float thickness;
        private Polyline.CapStyle capStyle;
        private Polyline.JoinStyle joinStyle;
        private Polyline.DashStyle dashStyle;
        private float[] dashPattern;
        private Float dashOffset;
        private Polyline.ArrowStyle startArrowStyle;
        private Polyline.ArrowStyle endArrowStyle;
        private Integer color;
        private final Float elevation;
        private final Boolean elevationEnabled;

        private PolylinesModificationUndoableEdit(Home home, UserPreferences userPreferences, List<Selectable> list, ModifiedPolyline[] modifiedPolylineArray, Float f, Polyline.CapStyle capStyle, Polyline.JoinStyle joinStyle, Polyline.DashStyle dashStyle, float[] fArray, Float f2, Polyline.ArrowStyle arrowStyle, Polyline.ArrowStyle arrowStyle2, Integer n, Float f3, Boolean bl) {
            this.home = home;
            this.preferences = userPreferences;
            this.oldSelection = list;
            this.modifiedPolylines = modifiedPolylineArray;
            this.thickness = f;
            this.capStyle = capStyle;
            this.joinStyle = joinStyle;
            this.dashStyle = dashStyle;
            this.dashPattern = fArray;
            this.dashOffset = f2;
            this.startArrowStyle = arrowStyle;
            this.endArrowStyle = arrowStyle2;
            this.color = n;
            this.elevation = f3;
            this.elevationEnabled = bl;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            PolylineController.undoModifyPolylines(this.modifiedPolylines);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            PolylineController.doModifyPolylines(this.modifiedPolylines, this.thickness, this.capStyle, this.joinStyle, this.dashStyle, this.dashPattern, this.dashOffset, this.startArrowStyle, this.endArrowStyle, this.color, this.elevation, this.elevationEnabled);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public String getPresentationName() {
            return this.preferences.getLocalizedString(PolylineController.class, "undoModifyPolylinesName", new Object[0]);
        }
    }

    public static enum Property {
        THICKNESS,
        CAP_STYLE,
        JOIN_STYLE,
        DASH_STYLE,
        DASH_PATTERN,
        DASH_OFFSET,
        START_ARROW_STYLE,
        END_ARROW_STYLE,
        COLOR,
        ELEVATION;

    }
}

