/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import java.io.File;
import java.io.Serializable;
import sbt.librarymanagement.ArtifactTypeFilter;
import sbt.librarymanagement.ArtifactTypeFilter$;
import sbt.librarymanagement.Configuration;
import sbt.librarymanagement.Configurations$;
import sbt.librarymanagement.DependencyResolution;
import sbt.librarymanagement.ModuleDescriptor;
import sbt.librarymanagement.Resolver$;
import sbt.librarymanagement.RetrieveConfiguration;
import sbt.librarymanagement.RetrieveConfiguration$;
import sbt.librarymanagement.UnresolvedWarning;
import sbt.librarymanagement.UnresolvedWarningConfiguration;
import sbt.librarymanagement.UnresolvedWarningConfiguration$;
import sbt.librarymanagement.UpdateConfiguration;
import sbt.librarymanagement.UpdateConfiguration$;
import sbt.librarymanagement.UpdateLogging;
import sbt.librarymanagement.UpdateReport;
import sbt.librarymanagement.syntax$;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ZincLMHelper$ {
    public static ZincLMHelper$ MODULE$;
    private final UnresolvedWarningConfiguration warningConf;
    private final String defaultRetrievePattern;
    private final Vector<Configuration> DefaultConfigurations;

    static {
        new ZincLMHelper$();
    }

    private final UnresolvedWarningConfiguration warningConf() {
        return this.warningConf;
    }

    private final String defaultRetrievePattern() {
        return this.defaultRetrievePattern;
    }

    public final Vector<Configuration> DefaultConfigurations() {
        return this.DefaultConfigurations;
    }

    public Either<UnresolvedWarning, Vector<File>> update(DependencyResolution dependencyResolution, ModuleDescriptor module, File retrieveDirectory, boolean noSource, Logger logger) {
        Left left;
        UpdateConfiguration updateConfiguration = this.defaultUpdateConfiguration(retrieveDirectory, noSource);
        String dependencies = this.prettyPrintDependency(module);
        logger.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Attempting to fetch ").append(dependencies).append(".").toString());
        Either either = dependencyResolution.update(module, updateConfiguration, this.warningConf(), logger);
        if (either instanceof Left) {
            Left left2 = (Left)either;
            UnresolvedWarning unresolvedWarning = (UnresolvedWarning)left2.value();
            logger.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Couldn't retrieve module(s) ").append(MODULE$.prettyPrintDependency(module)).append(".").toString());
            left = package$.MODULE$.Left().apply((Object)unresolvedWarning);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            UpdateReport updateReport = (UpdateReport)right.value();
            Vector allFiles = syntax$.MODULE$.richUpdateReport(updateReport).allFiles();
            logger.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Files retrieved for ").append(MODULE$.prettyPrintDependency(module)).append(":").toString());
            logger.debug((Function0 & Serializable & scala.Serializable)() -> allFiles.mkString(", "));
            left = package$.MODULE$.Right().apply((Object)allFiles);
        } else {
            throw new MatchError((Object)either);
        }
        return left;
    }

    public boolean update$default$4() {
        return false;
    }

    private UpdateConfiguration defaultUpdateConfiguration(File targetDir, boolean noSource) {
        RetrieveConfiguration retrieve = RetrieveConfiguration$.MODULE$.apply().withRetrieveDirectory(targetDir).withOutputPattern(this.defaultRetrievePattern());
        UpdateLogging.DownloadOnly$ logLevel = UpdateLogging.DownloadOnly$.MODULE$;
        Set defaultExcluded = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"doc"}));
        Set finalExcluded = noSource ? (Set)defaultExcluded.$plus((Object)"src") : defaultExcluded;
        ArtifactTypeFilter artifactFilter = ArtifactTypeFilter$.MODULE$.forbid(finalExcluded);
        return UpdateConfiguration$.MODULE$.apply().withRetrieveManaged(retrieve).withLogging((UpdateLogging)logLevel).withArtifactFilter(artifactFilter);
    }

    private String prettyPrintDependency(ModuleDescriptor module) {
        return ((TraversableOnce)module.directDependencies().map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(2).append(m.organization()).append(":").append(m.name()).append(":").append(m.revision()).toString(), Vector$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private ZincLMHelper$() {
        MODULE$ = this;
        this.warningConf = UnresolvedWarningConfiguration$.MODULE$.apply();
        this.defaultRetrievePattern = Resolver$.MODULE$.defaultRetrievePattern();
        this.DefaultConfigurations = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Configuration[]{Configurations$.MODULE$.Component(), Configurations$.MODULE$.Compile()}));
    }
}

