/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.PrintFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import processing.app.Base;
import processing.app.Language;
import processing.app.ui.About;
import processing.app.ui.Toolkit;

public class ThinkDifferent {
    private static ThinkDifferent adapter;
    private static Application application;

    protected static void init(final Base base) {
        if (application == null) {
            application = Application.getApplication();
        }
        if (adapter == null) {
            adapter = new ThinkDifferent();
        }
        application.setAboutHandler(new AboutHandler(){

            public void handleAbout(AppEvent.AboutEvent ae) {
                new About(null);
            }
        });
        application.setPreferencesHandler(new PreferencesHandler(){

            public void handlePreferences(AppEvent.PreferencesEvent arg0) {
                base.handlePrefs();
            }
        });
        application.setOpenFileHandler(new OpenFilesHandler(){

            public void openFiles(AppEvent.OpenFilesEvent event) {
                for (File file : event.getFiles()) {
                    base.handleOpen(file.getAbsolutePath());
                }
            }
        });
        application.setPrintFileHandler(new PrintFilesHandler(){

            public void printFiles(AppEvent.PrintFilesEvent event) {
            }
        });
        application.setQuitHandler(new QuitHandler(){

            public void handleQuitRequestWith(AppEvent.QuitEvent event, QuitResponse response) {
                if (base.handleQuit()) {
                    response.performQuit();
                } else {
                    response.cancelQuit();
                }
            }
        });
        JMenuBar defaultMenuBar = new JMenuBar();
        JMenu fileMenu = ThinkDifferent.buildFileMenu(base);
        defaultMenuBar.add(fileMenu);
        Base.defaultFileMenu = fileMenu;
        try {
            application.setDefaultMenuBar(defaultMenuBar);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static JMenu buildFileMenu(final Base base) {
        JMenu fileMenu = new JMenu(Language.text("menu.file"));
        JMenuItem item = Toolkit.newJMenuItem(Language.text("menu.file.new"), 78);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                base.handleNew();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItem(Language.text("menu.file.open"), 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                base.handleOpenPrompt();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.sketchbook"), 75);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                base.getNextMode().showSketchbookFrame();
            }
        });
        fileMenu.add(item);
        item = Toolkit.newJMenuItemShift(Language.text("menu.file.examples"), 79);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                base.thinkDifferentExamples();
            }
        });
        fileMenu.add(item);
        return fileMenu;
    }
}

