/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.tweak;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import processing.mode.java.pdex.JavaTextAreaPainter;
import processing.mode.java.tweak.ColorMode;
import processing.mode.java.tweak.Handle;
import processing.mode.java.tweak.Settings;

public class ColorControlBox {
    public boolean visible;
    ArrayList<Handle> handles;
    ColorMode colorMode;
    Color color;
    boolean ilegalColor = false;
    boolean isBW;
    boolean isHex;
    String drawContext;
    int x;
    int y;
    int width;
    int height;
    JavaTextAreaPainter painter;

    public ColorControlBox(String context, ColorMode mode, ArrayList<Handle> handles) {
        this.drawContext = context;
        this.colorMode = mode;
        this.handles = handles;
        for (Handle h : handles) {
            h.setColorBox(this);
        }
        this.isBW = this.isGrayScale();
        this.isHex = this.isHexColor();
        this.color = this.getCurrentColor();
        this.visible = Settings.alwaysShowColorBoxes;
    }

    public void initInterface(JavaTextAreaPainter textAreaPainter, int x, int y, int w, int h) {
        this.painter = textAreaPainter;
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void draw(Graphics2D g2d) {
        if (!this.visible) {
            return;
        }
        AffineTransform trans = g2d.getTransform();
        g2d.translate(this.x, this.y);
        g2d.setColor(this.color);
        g2d.fillRoundRect(0, 0, this.width, this.height, 5, 5);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.setColor(Color.BLACK);
        g2d.drawRoundRect(0, 0, this.width, this.height, 5, 5);
        if (this.ilegalColor) {
            g2d.setColor(Color.RED);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.drawLine(this.width - 3, 3, 3, this.height - 3);
        }
        g2d.setTransform(trans);
    }

    public boolean isGrayScale() {
        int value;
        return this.handles.size() <= 2 && ((value = this.handles.get((int)0).newValue.intValue()) & 0xFF000000) == 0;
    }

    private boolean isHexColor() {
        int value;
        return (this.handles.get((int)0).type == "hex" || this.handles.get((int)0).type == "webcolor") && ((value = this.handles.get((int)0).value.intValue()) & 0xFF000000) != 0;
    }

    public Color getCurrentColor() {
        try {
            if (this.handles.size() == 1) {
                if (this.isBW) {
                    float gray = this.handles.get((int)0).newValue.floatValue();
                    return this.verifiedGrayColor(gray);
                }
                int argb = this.handles.get((int)0).newValue.intValue();
                return this.verifiedHexColor(argb);
            }
            if (this.handles.size() == 2) {
                if (this.isBW) {
                    float gray = this.handles.get((int)0).newValue.floatValue();
                    return this.verifiedGrayColor(gray);
                }
                int argb = this.handles.get((int)0).newValue.intValue();
                float a = this.handles.get((int)1).newValue.floatValue();
                return this.verifiedHexColor(argb, a);
            }
            if (this.handles.size() == 3) {
                float v1 = this.handles.get((int)0).newValue.floatValue();
                float v2 = this.handles.get((int)1).newValue.floatValue();
                float v3 = this.handles.get((int)2).newValue.floatValue();
                if (this.colorMode.modeType == 0) {
                    return this.verifiedRGBColor(v1, v2, v3, this.colorMode.aMax);
                }
                return this.verifiedHSBColor(v1, v2, v3, this.colorMode.aMax);
            }
            if (this.handles.size() == 4) {
                float v1 = this.handles.get((int)0).newValue.floatValue();
                float v2 = this.handles.get((int)1).newValue.floatValue();
                float v3 = this.handles.get((int)2).newValue.floatValue();
                float a = this.handles.get((int)3).newValue.floatValue();
                if (this.colorMode.modeType == 0) {
                    return this.verifiedRGBColor(v1, v2, v3, a);
                }
                return this.verifiedHSBColor(v1, v2, v3, a);
            }
        }
        catch (Exception e) {
            System.out.println("error parsing color value: " + e.toString());
            this.ilegalColor = true;
            return Color.WHITE;
        }
        this.ilegalColor = true;
        return Color.WHITE;
    }

    private Color verifiedGrayColor(float gray) {
        if (gray < 0.0f || gray > this.colorMode.v1Max) {
            return this.colorError();
        }
        this.ilegalColor = false;
        gray = gray / this.colorMode.v1Max * 255.0f;
        return new Color((int)gray, (int)gray, (int)gray, 255);
    }

    private Color verifiedHexColor(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        this.ilegalColor = false;
        return new Color(r, g, b, 255);
    }

    private Color verifiedHexColor(int argb, float alpha) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        this.ilegalColor = false;
        return new Color(r, g, b, 255);
    }

    public Color verifiedRGBColor(float r, float g, float b, float a) {
        if (r < 0.0f || r > this.colorMode.v1Max || g < 0.0f || g > this.colorMode.v2Max || b < 0.0f || b > this.colorMode.v3Max) {
            return this.colorError();
        }
        this.ilegalColor = false;
        r = r / this.colorMode.v1Max * 255.0f;
        g = g / this.colorMode.v2Max * 255.0f;
        b = b / this.colorMode.v3Max * 255.0f;
        return new Color((int)r, (int)g, (int)b, 255);
    }

    public Color verifiedHSBColor(float h, float s, float b, float a) {
        if (h < 0.0f || h > this.colorMode.v1Max || s < 0.0f || s > this.colorMode.v2Max || b < 0.0f || b > this.colorMode.v3Max) {
            return this.colorError();
        }
        this.ilegalColor = false;
        Color c = Color.getHSBColor(h / this.colorMode.v1Max, s / this.colorMode.v2Max, b / this.colorMode.v3Max);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), 255);
    }

    private Color colorError() {
        this.ilegalColor = true;
        return Color.WHITE;
    }

    public void colorChanged() {
        this.color = this.getCurrentColor();
    }

    public int getTabIndex() {
        return this.handles.get((int)0).tabIndex;
    }

    public int getLine() {
        return this.handles.get((int)0).line;
    }

    public int getCharIndex() {
        int lastHandle = this.handles.size() - 1;
        return this.handles.get((int)lastHandle).newEndChar + 2;
    }

    public boolean pick(int mx, int my) {
        if (!this.visible) {
            return false;
        }
        return mx > this.x && mx < this.x + this.width && my > this.y && my < this.y + this.height;
    }

    public boolean setMouseY(int my) {
        boolean change = false;
        if (my > this.y && my < this.y + this.height) {
            if (!this.visible) {
                change = true;
            }
            this.visible = true;
        } else {
            if (this.visible) {
                change = true;
            }
            this.visible = false;
        }
        return change;
    }

    public void selectorChanged(int hue, int saturation, int brightness) {
        if (this.isBW) {
            this.handles.get(0).setValue(Float.valueOf((float)hue / 255.0f * this.colorMode.v1Max));
        } else if (this.handles.size() == 1 || this.handles.size() == 2) {
            int prevVal = this.handles.get((int)0).newValue.intValue();
            int prevAlpha = prevVal >> 24 & 0xFF;
            Color c = Color.getHSBColor((float)hue / 255.0f, (float)saturation / 255.0f, (float)brightness / 255.0f);
            int newVal = prevAlpha << 24 | c.getRed() << 16 | c.getGreen() << 8 | c.getBlue();
            this.handles.get(0).setValue(newVal);
        } else if (this.handles.size() == 3 || this.handles.size() == 4) {
            if (this.colorMode.modeType == 1) {
                float v1 = (float)hue / 255.0f * this.colorMode.v1Max;
                float v2 = (float)saturation / 255.0f * this.colorMode.v2Max;
                float v3 = (float)brightness / 255.0f * this.colorMode.v3Max;
                this.handles.get(0).setValue(Float.valueOf(v1));
                this.handles.get(1).setValue(Float.valueOf(v2));
                this.handles.get(2).setValue(Float.valueOf(v3));
            } else {
                Color c = Color.getHSBColor((float)hue / 255.0f, (float)saturation / 255.0f, (float)brightness / 255.0f);
                this.handles.get(0).setValue(Float.valueOf((float)c.getRed() / 255.0f * this.colorMode.v1Max));
                this.handles.get(1).setValue(Float.valueOf((float)c.getGreen() / 255.0f * this.colorMode.v2Max));
                this.handles.get(2).setValue(Float.valueOf((float)c.getBlue() / 255.0f * this.colorMode.v3Max));
            }
        }
        this.color = this.getCurrentColor();
        this.painter.updateCodeText();
        this.painter.repaint();
    }

    public String toString() {
        return String.valueOf(this.handles.size()) + " handles, color mode: " + this.colorMode.toString();
    }
}

