/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendMessageRequestMarshaller
implements Marshaller<Request<SendMessageRequest>, SendMessageRequest> {
    @Override
    public Request<SendMessageRequest> marshall(SendMessageRequest sendMessageRequest) {
        DefaultRequest<SendMessageRequest> request = new DefaultRequest<SendMessageRequest>(sendMessageRequest, "AmazonSQS");
        request.addParameter("Action", "SendMessage");
        request.addParameter("Version", "2009-02-01");
        if (sendMessageRequest != null && sendMessageRequest.getQueueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString(sendMessageRequest.getQueueUrl()));
        }
        if (sendMessageRequest != null && sendMessageRequest.getMessageBody() != null) {
            request.addParameter("MessageBody", StringUtils.fromString(sendMessageRequest.getMessageBody()));
        }
        return request;
    }
}

