/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.openide.util.NbBundle;

public enum GlassFishJvmMode {
    NORMAL,
    DEBUG,
    PROFILE;

    private static final Logger LOGGER;
    public static final int length;
    private static final String NORMAL_STR = "normalMode";
    private static final String DEBUG_STR = "debugMode";
    private static final String PROFILE_STR = "profileMode";
    private static final Map<String, GlassFishJvmMode> stringValuesMap;

    public static GlassFishJvmMode toValue(String name) {
        if (name != null) {
            return stringValuesMap.get(name.toUpperCase());
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case NORMAL: {
                return NORMAL_STR;
            }
            case DEBUG: {
                return DEBUG_STR;
            }
            case PROFILE: {
                return PROFILE_STR;
            }
        }
        throw new IllegalStateException(NbBundle.getMessage(GlassFishJvmMode.class, (String)"GlassFishJvmMode.toString.invalid"));
    }

    static {
        LOGGER = GlassFishLogger.get(GlassFishJvmMode.class);
        length = GlassFishJvmMode.values().length;
        stringValuesMap = new HashMap<String, GlassFishJvmMode>(length);
        for (GlassFishJvmMode mode : GlassFishJvmMode.values()) {
            stringValuesMap.put(mode.toString().toUpperCase(), mode);
        }
    }
}

