/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.tables;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.ddloaders.Utils;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.tables.GenericTableDialogPanelAccessor;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.tables.TableEntry;

public class GenericTableDialogPanel
extends JPanel
implements GenericTableDialogPanelAccessor {
    private final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.Bundle");
    private List<TableEntry> fieldEntries;
    private String[] values;
    private JTextField[] textFields;
    private int preferredWidth;

    @Override
    public void init(ASDDVersion asVersion, int width, List<TableEntry> entries, Object data) {
        this.fieldEntries = entries;
        this.preferredWidth = width;
        this.values = new String[entries.size()];
        this.textFields = new JTextField[entries.size()];
        this.initUserComponents();
    }

    @Override
    public void setValues(Object[] v) {
        if (v != null && v.length == this.values.length) {
            for (int i = 0; i < this.values.length && i < v.length; ++i) {
                this.values[i] = v[i] != null ? v[i].toString() : "";
            }
        } else {
            if (v != null) assert (v.length == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = "";
            }
        }
        this.setComponentValues();
    }

    @Override
    public Object[] getValues() {
        return this.values;
    }

    private void setComponentValues() {
        for (int i = 0; i < this.values.length; ++i) {
            this.textFields[i].setText(this.values[i]);
        }
    }

    private void initUserComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(5, 5, 0, 5)));
        this.setPreferredSize(new Dimension(this.preferredWidth, 22 * this.fieldEntries.size() + 8));
        for (int i = 0; i < this.fieldEntries.size(); ++i) {
            TableEntry entry = this.fieldEntries.get(i);
            JLabel requiredMark = new JLabel();
            JLabel label = new JLabel();
            this.textFields[i] = new JTextField();
            if (entry.isRequiredField()) {
                requiredMark.setText(this.bundle.getString("LBL_RequiredMark"));
                requiredMark.getAccessibleContext().setAccessibleName(this.bundle.getString("ACSN_RequiredMark"));
                requiredMark.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_RequiredMark"));
            }
            requiredMark.setLabelFor(this.textFields[i]);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 4, 4);
            this.add((Component)requiredMark, gridBagConstraints);
            label.setLabelFor(this.textFields[i]);
            label.setText(entry.getLabelName());
            label.setDisplayedMnemonic(entry.getLabelMnemonic());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 4, 4);
            this.add((Component)label, gridBagConstraints);
            this.textFields[i].addKeyListener(new TextFieldHandler(this.textFields[i], i));
            this.textFields[i].getAccessibleContext().setAccessibleName(entry.getAccessibleName());
            this.textFields[i].getAccessibleContext().setAccessibleDescription(entry.getAccessibleDescription());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 4, 0);
            this.add((Component)this.textFields[i], gridBagConstraints);
        }
    }

    @Override
    public boolean requiredFieldsFilled() {
        boolean result = true;
        for (int i = 0; i < this.fieldEntries.size(); ++i) {
            TableEntry entry = this.fieldEntries.get(i);
            if (!entry.isRequiredField() || Utils.notEmpty(this.values[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    private class TextFieldHandler
    extends KeyAdapter {
        private JTextField textField;
        private int controlIndex;

        public TextFieldHandler(JTextField tf, int index) {
            this.textField = tf;
            this.controlIndex = index;
        }

        @Override
        public void keyReleased(KeyEvent evt) {
            ((GenericTableDialogPanel)GenericTableDialogPanel.this).values[this.controlIndex] = this.textField.getText();
            GenericTableDialogPanel.this.firePropertyChange("UserDataChanged", null, null);
        }
    }
}

