/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.ui.actions.Command;
import org.netbeans.modules.javascript.nodejs.ui.actions.DebugFileCommand;
import org.netbeans.modules.javascript.nodejs.ui.actions.DebugProjectCommand;
import org.netbeans.modules.javascript.nodejs.ui.actions.RunFileCommand;
import org.netbeans.modules.javascript.nodejs.ui.actions.RunProjectCommand;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class NodeJsActionProvider
implements ActionProvider {
    private static final RequestProcessor RP = new RequestProcessor(NodeJsActionProvider.class);
    private final Project project;
    private final Map<String, Command> commands = new ConcurrentHashMap<String, Command>();
    private final List<String> supportedActions;

    public NodeJsActionProvider(Project project) {
        assert (project != null);
        this.project = project;
        this.fillCommands();
        this.supportedActions = new ArrayList<String>(this.commands.keySet());
    }

    private void fillCommands() {
        Command[] allCommands;
        for (Command command : allCommands = new Command[]{new RunProjectCommand(this.project), new RunFileCommand(this.project), new DebugProjectCommand(this.project), new DebugFileCommand(this.project)}) {
            Command old = this.commands.put(command.getCommandId(), command);
            assert (old == null) : "Command already set for " + command.getCommandId();
        }
    }

    public String[] getSupportedActions() {
        return this.supportedActions.toArray(new String[this.supportedActions.size()]);
    }

    public void invokeAction(String command, final Lookup context) {
        final Command runCommand = this.commands.get(command);
        assert (runCommand != null) : command;
        RP.post(new Runnable(){

            @Override
            public void run() {
                runCommand.run(context);
            }
        });
    }

    public boolean isActionEnabled(String command, Lookup context) {
        Command runCommand = this.commands.get(command);
        if (runCommand == null) {
            return false;
        }
        return runCommand.isEnabled(context);
    }
}

