/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.diff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import org.netbeans.api.diff.Difference;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.diff.DiffModuleConfig;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;

class DiffTooltipContentPanel
extends JComponent {
    private JEditorPane originalTextPane = new JEditorPane();
    private final Color color;
    private int maxWidth;
    private final JScrollPane jsp;
    private Integer spacesPerTab;

    public DiffTooltipContentPanel(JTextComponent parentPane, String mimeType, Difference diff) {
        EditorKit kit = CloneableEditorSupport.getEditorKit((String)mimeType);
        this.originalTextPane.setEditorKit(kit);
        Document xdoc = kit.createDefaultDocument();
        if (!(xdoc instanceof StyledDocument)) {
            xdoc = new DefaultStyledDocument(new StyleContext());
            kit = new StyledEditorKit();
            this.originalTextPane.setEditorKit(kit);
        }
        StyledDocument doc = (StyledDocument)xdoc;
        try {
            kit.read(new StringReader(diff.getFirstText()), (Document)doc, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.originalTextPane.setDocument(doc);
        this.originalTextPane.setEditable(false);
        this.color = this.getBackgroundColor(diff.getType());
        this.originalTextPane.setBackground(this.color);
        EditorUI eui = Utilities.getEditorUI((JTextComponent)this.originalTextPane);
        Element rootElement = NbDocument.findLineRootElement((StyledDocument)doc);
        int lineCount = rootElement.getElementCount();
        int height = eui.getLineHeight() * lineCount;
        this.maxWidth = 0;
        for (int line = 0; line < lineCount; ++line) {
            Element lineElement = rootElement.getElement(line);
            String text = null;
            try {
                text = doc.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            text = this.replaceTabs(mimeType, text);
            int lineLength = parentPane.getFontMetrics(parentPane.getFont()).stringWidth(text);
            if (lineLength <= this.maxWidth) continue;
            this.maxWidth = lineLength;
        }
        if (this.maxWidth < 50) {
            this.maxWidth = 50;
        } else if (this.maxWidth < 150) {
            this.maxWidth += 10;
        }
        this.maxWidth = Math.min(this.maxWidth * 7 / 6, parentPane.getVisibleRect().width);
        this.originalTextPane.setPreferredSize(new Dimension(this.maxWidth, height));
        if (!this.originalTextPane.isEditable()) {
            this.originalTextPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        }
        this.jsp = new JScrollPane(this.originalTextPane);
        this.jsp.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK));
        this.setLayout(new BorderLayout());
        this.add(this.jsp);
    }

    void resize() {
        if (this.originalTextPane == null) {
            return;
        }
        this.originalTextPane.setBackground(this.color);
        Element rootElement = NbDocument.findLineRootElement((StyledDocument)((StyledDocument)this.originalTextPane.getDocument()));
        int lineCount = rootElement.getElementCount();
        int height = 0;
        assert (lineCount > 0);
        Element lineElement = rootElement.getElement(lineCount - 1);
        try {
            Rectangle rec = this.originalTextPane.modelToView(lineElement.getEndOffset() - 1);
            height = rec.y + rec.height;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (height > 0) {
            Dimension size = this.originalTextPane.getPreferredSize();
            Dimension scrollpaneSize = this.jsp.getPreferredSize();
            this.jsp.setPreferredSize(new Dimension(this.maxWidth + Math.max(0, scrollpaneSize.width - size.width), (height += this.jsp.getHorizontalScrollBar().getPreferredSize().height) + Math.max(0, scrollpaneSize.height - size.height)));
            SwingUtilities.getWindowAncestor(this.originalTextPane).pack();
        }
        this.originalTextPane = null;
    }

    private Color getBackgroundColor(int key) {
        DiffModuleConfig config = DiffModuleConfig.getDefault();
        return key == 0 ? config.getSidebarDeletedColor() : config.getSidebarChangedColor();
    }

    private String replaceTabs(String mimeType, String text) {
        if (text.contains("\t")) {
            if (this.spacesPerTab == null) {
                this.spacesPerTab = DiffModuleConfig.getDefault().getSpacesPerTabFor(mimeType);
            }
            text = text.replace("\t", DiffTooltipContentPanel.strCharacters(' ', this.spacesPerTab));
        }
        return text;
    }

    private static String strCharacters(char c, int num) {
        StringBuffer s = new StringBuffer();
        while (num-- > 0) {
            s.append(c);
        }
        return s.toString();
    }
}

