/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.api.output;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.gradle.java.api.output.Location;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public final class LocationOpener {
    public static final Location.Finder GLOBAL_FINDER = new Location.Finder(){

        @Override
        public FileObject findFileObject(Location loc) {
            return GlobalPathRegistry.getDefault().findResource(loc.getFileName());
        }
    };
    final Location location;
    final Location.Finder finder;

    public LocationOpener(Location location, Location.Finder finder) {
        this.location = location;
        this.finder = finder;
    }

    public LocationOpener(Location location) {
        this(location, GLOBAL_FINDER);
    }

    public final void open() {
        FileObject fo = this.finder.findFileObject(this.location);
        if (fo != null) {
            if (this.location.isLine()) {
                LocationOpener.openAtLine(fo, this.location.getLineNum());
            } else if (this.location.isMethod()) {
                int l = this.getMethodLine(fo, this.location.getTarget());
                LocationOpener.openAtLine(fo, l);
            } else {
                int l = this.getTargetLine(fo);
                LocationOpener.openAtLine(fo, l);
            }
        }
    }

    private int getMethodLine(final FileObject fo, final String methodName) {
        final int[] line = new int[1];
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Trees trees = compilationController.getTrees();
                        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                        List<? extends Tree> typeDecls = compilationUnitTree.getTypeDecls();
                        block0: for (Tree tree : typeDecls) {
                            Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                            if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fo.getName())) continue;
                            List<ExecutableElement> methodElements = ElementFilter.methodsIn(element.getEnclosedElements());
                            for (Element element2 : methodElements) {
                                if (!element2.getSimpleName().contentEquals(methodName)) continue;
                                long pos = trees.getSourcePositions().getStartPosition(compilationUnitTree, trees.getTree(element2));
                                line[0] = (int)compilationUnitTree.getLineMap().getLineNumber(pos);
                                continue block0;
                            }
                        }
                    }
                }, true);
                return line[0];
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 1;
    }

    private int getTargetLine(final FileObject fo) {
        final int[] line = new int[]{0};
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fo);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Trees trees = compilationController.getTrees();
                        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                        List<? extends Tree> typeDecls = compilationUnitTree.getTypeDecls();
                        for (Tree tree : typeDecls) {
                            Element element = trees.getElement(trees.getPath(compilationUnitTree, tree));
                            if (element == null || element.getKind() != ElementKind.CLASS || !element.getSimpleName().contentEquals(fo.getName())) continue;
                            long pos = trees.getSourcePositions().getStartPosition(compilationUnitTree, tree);
                            line[0] = (int)compilationUnitTree.getLineMap().getLineNumber(pos);
                            break;
                        }
                    }
                }, true);
                return line[0];
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 1;
    }

    public static void openAtLine(FileObject file, int line) {
        LocationOpener.openAtLine(file, line, false);
    }

    public static void openAtLine(FileObject file, final int line, final boolean reuse) {
        try {
            LineCookie lines;
            DataObject data = DataObject.find((FileObject)file);
            if (data != null && (lines = (LineCookie)data.getLookup().lookup(LineCookie.class)) != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            lines.getLineSet().getOriginal(line - 1).show(reuse ? Line.ShowOpenType.REUSE : Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, 0);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
    }
}

