/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.apache.tomcat.net.ServerSocketFactory;
import org.apache.tomcat.service.PoolTcpEndpoint;
import org.apache.tomcat.service.TcpConnection;
import org.apache.tomcat.service.TcpConnectionHandler;
import org.apache.tomcat.service.TcpConnectionThread;
import org.apache.tomcat.service.TcpListenerThread;
import org.apache.tomcat.util.StringManager;

public class SimpleTcpEndpoint
extends PoolTcpEndpoint {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    private static final int BACKLOG = 100;
    private static final int TIMEOUT = 5000;
    private int backlog = 100;
    private int timeout = 5000;
    TcpConnectionHandler handler;
    private InetAddress inet;
    private int port;
    private ServerSocketFactory factory;
    private ServerSocket serverSocket;
    Runnable listener;
    boolean running = true;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.inet;
    }

    public void setAddress(InetAddress inet) {
        this.inet = inet;
    }

    public void setServerSocket(ServerSocket ss) {
        this.serverSocket = ss;
    }

    public void setServerSocketFactory(ServerSocketFactory factory) {
        this.factory = factory;
    }

    public void setConnectionHandler(TcpConnectionHandler handler) {
        this.handler = handler;
    }

    public TcpConnectionHandler getConnectionHandler() {
        return this.handler;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void startEndpoint() throws IOException, InstantiationException {
        try {
            if (this.factory == null) {
                this.factory = ServerSocketFactory.getDefault();
            }
            if (this.serverSocket == null) {
                this.serverSocket = this.inet == null ? this.factory.createSocket(this.port, this.backlog) : this.factory.createSocket(this.port, this.backlog, this.inet);
                if (this.serverSocket != null) {
                    this.serverSocket.setSoTimeout(this.timeout);
                }
            }
        }
        catch (IOException ex) {
            this.running = false;
            throw ex;
        }
        catch (InstantiationException ex1) {
            this.running = false;
            throw ex1;
        }
        this.running = true;
        this.listener = new TcpListenerThread(this);
        Thread thread = new Thread(this.listener);
        thread.start();
    }

    public void stopEndpoint() {
        this.running = false;
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.serverSocket = null;
    }

    void processSocket(Socket s) throws IOException {
        TcpConnection con = new TcpConnection();
        con.setEndpoint(this);
        con.setSocket(s);
        TcpConnectionHandler handler = this.getConnectionHandler();
        TcpConnectionThread handlerThread = new TcpConnectionThread(handler, con);
        new Thread(handlerThread).start();
    }

    void acceptConnections() {
        try {
            if (!this.running) {
                return;
            }
            if (null != this.serverSocket) {
                Socket socket = this.acceptSocket();
                if (this.running) {
                    this.processSocket(socket);
                }
            }
        }
        catch (Throwable e) {
            this.running = false;
            String msg = sm.getString("endpoint.err.fatal", this.serverSocket, e);
            e.printStackTrace();
            System.err.println(msg);
        }
    }

    Socket acceptSocket() {
        Socket accepted = null;
        try {
            if (this.running && null != this.serverSocket) {
                accepted = this.serverSocket.accept();
                if (!this.running && null != accepted) {
                    accepted.close();
                    accepted = null;
                }
            }
        }
        catch (InterruptedIOException iioe) {
        }
        catch (SocketException e) {
            if (this.running) {
                this.running = false;
                String msg = sm.getString("endpoint.err.fatal", this.serverSocket, e);
                e.printStackTrace();
                System.err.println(msg);
            }
        }
        catch (Throwable e) {
            this.running = false;
            String msg = sm.getString("endpoint.err.fatal", this.serverSocket, e);
            e.printStackTrace();
            System.err.println(msg);
        }
        return accepted;
    }
}

