/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.menus;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.MenuDriver;
import org.netbeans.jemmy.drivers.MouseDriver;
import org.netbeans.jemmy.drivers.PathChooser;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JMenuBarOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JMenuOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;

public class DefaultJMenuDriver
extends LightSupportiveDriver
implements MenuDriver {
    public DefaultJMenuDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JMenuOperator", "org.netbeans.jemmy.operators.JMenuBarOperator", "org.netbeans.jemmy.operators.JPopupMenuOperator"});
    }

    @Override
    public Object pushMenu(ComponentOperator oper, PathChooser chooser) {
        this.checkSupported(oper);
        if (oper instanceof JMenuBarOperator || oper instanceof JPopupMenuOperator) {
            JMenuItem item = oper instanceof JMenuBarOperator ? this.waitItem(oper, (JMenuBar)oper.getSource(), chooser, 0) : this.waitItem(oper, (JPopupMenu)oper.getSource(), chooser, 0);
            JMenuItemOperator itemOper = item instanceof JMenu ? new JMenuOperator((JMenu)item) : new JMenuItemOperator(item);
            itemOper.copyEnvironment(oper);
            return this.push(itemOper, null, oper instanceof JMenuBarOperator ? (JMenuBar)oper.getSource() : null, chooser, 1, true);
        }
        return this.push(oper, null, null, chooser, 0, true);
    }

    protected Object push(ComponentOperator oper, ComponentOperator lastItem, JMenuBar menuBar, PathChooser chooser, int depth, boolean pressMouse) {
        try {
            oper.waitComponentVisible(true);
            oper.waitComponentEnabled();
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted!", e);
        }
        MouseDriver mDriver = DriverManager.getMouseDriver(oper);
        this.smartMove(lastItem, oper);
        if (depth > chooser.getDepth() - 1) {
            if (!(oper instanceof JMenuOperator) || menuBar == null || DefaultJMenuDriver.getSelectedElement(menuBar) == null) {
                DriverManager.getButtonDriver(oper).push(oper);
            }
            return oper.getSource();
        }
        if (pressMouse && !((JMenuOperator)oper).isPopupMenuVisible() && (menuBar == null || DefaultJMenuDriver.getSelectedElement(menuBar) == null)) {
            DriverManager.getButtonDriver(oper).push(oper);
        }
        oper.getTimeouts().sleep("JMenuOperator.WaitBeforePopupTimeout");
        JMenuItem item = this.waitItem(oper, this.waitPopupMenu(oper), chooser, depth);
        mDriver.exitMouse(oper);
        if (item instanceof JMenu) {
            JMenuOperator mo = new JMenuOperator((JMenu)item);
            mo.copyEnvironment(oper);
            return this.push(mo, oper, null, chooser, depth + 1, false);
        }
        JMenuItemOperator mio = new JMenuItemOperator(item);
        mio.copyEnvironment(oper);
        try {
            mio.waitComponentEnabled();
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted!", e);
        }
        this.smartMove(oper, mio);
        DriverManager.getButtonDriver(oper).push(mio);
        return item;
    }

    private void smartMove(ComponentOperator last, ComponentOperator oper) {
        long overYr;
        if (last == null) {
            oper.enterMouse();
            return;
        }
        long lastXl = (long)last.getSource().getLocationOnScreen().getX();
        long lastXr = lastXl + (long)last.getSource().getWidth();
        long lastYl = (long)last.getSource().getLocationOnScreen().getY();
        long lastYr = lastYl + (long)last.getSource().getHeight();
        long operXl = (long)oper.getSource().getLocationOnScreen().getX();
        long operXr = operXl + (long)oper.getSource().getWidth();
        long operYl = (long)oper.getSource().getLocationOnScreen().getY();
        long operYr = operYl + (long)oper.getSource().getHeight();
        long overXl = lastXl > operXl ? lastXl : operXl;
        long overXr = lastXr < operXr ? lastXr : operXr;
        long overYl = lastYl > operYl ? lastYl : operYl;
        long l = overYr = lastYr < operYr ? lastYr : operYr;
        if (overXl < overXr) {
            last.moveMouse((int)((overXr - overXl) / 2L - lastXl), last.getCenterY());
            oper.moveMouse((int)((overXr - overXl) / 2L - operXl), oper.getCenterY());
            oper.enterMouse();
            return;
        }
        if (overYl < overYr) {
            last.moveMouse(last.getCenterX(), (int)((overYr - overYl) / 2L - lastYl));
            oper.moveMouse(last.getCenterX(), (int)((overYr - overYl) / 2L - operYl));
            oper.enterMouse();
            return;
        }
        oper.enterMouse();
    }

    protected JPopupMenu waitPopupMenu(final ComponentOperator oper) {
        return (JPopupMenu)JPopupMenuOperator.waitJPopupMenu(new ComponentChooser(){

            @Override
            public boolean checkComponent(Component comp) {
                return comp == ((JMenuOperator)oper).getPopupMenu() && comp.isShowing();
            }

            @Override
            public String getDescription() {
                return ((JMenuOperator)oper).getText() + "'s popup";
            }
        }).getSource();
    }

    protected JMenuItem waitItem(ComponentOperator oper, MenuElement element, PathChooser chooser, int depth) {
        Waiter waiter = new Waiter(new JMenuItemWaiter(element, chooser, depth));
        waiter.setOutput(oper.getOutput().createErrorOutput());
        waiter.setTimeouts(oper.getTimeouts());
        try {
            return (JMenuItem)waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Waiting has been interrupted", e);
        }
    }

    public static Object getSelectedElement(JMenuBar bar) {
        MenuElement[] subElements = bar.getSubElements();
        for (int i = 0; i < subElements.length; ++i) {
            if (!(subElements[i] instanceof JMenu) || !((JMenu)subElements[i]).isPopupMenuVisible()) continue;
            return subElements[i];
        }
        return null;
    }

    private static class JMenuItemWaiter
    implements Waitable {
        MenuElement cont;
        PathChooser chooser;
        int depth;

        public JMenuItemWaiter(MenuElement cont, PathChooser chooser, int depth) {
            this.cont = cont;
            this.chooser = chooser;
            this.depth = depth;
        }

        @Override
        public Object actionProduced(Object obj) {
            if (!((Component)((Object)this.cont)).isShowing()) {
                return null;
            }
            MenuElement[] subElements = this.cont.getSubElements();
            for (int i = 0; i < subElements.length; ++i) {
                if (!((Component)((Object)subElements[i])).isShowing() || !((Component)((Object)subElements[i])).isEnabled() || !this.chooser.checkPathComponent(this.depth, subElements[i])) continue;
                return subElements[i];
            }
            return null;
        }

        @Override
        public String getDescription() {
            return "";
        }
    }
}

