/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.TablesClause;
import org.netbeans.modules.db.sql.analyzer.UpdateStatement;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

class UpdateStatementAnalyzer
extends SQLStatementAnalyzer {
    private final List<SQLStatementAnalyzer.TableIdent> tables = new ArrayList<SQLStatementAnalyzer.TableIdent>();

    public static UpdateStatement analyze(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        seq.moveStart();
        if (!seq.moveNext()) {
            return null;
        }
        UpdateStatementAnalyzer sa = new UpdateStatementAnalyzer(seq, quoter);
        sa.parse();
        TablesClause tablesClause = sa.context.isAfter(SQLStatement.Context.FROM) ? sa.createTablesClause(sa.tables) : null;
        return new UpdateStatement(sa.startOffset, seq.offset() + seq.token().length(), tablesClause, Collections.unmodifiableList(sa.subqueries), sa.offset2Context);
    }

    private UpdateStatementAnalyzer(TokenSequence<SQLTokenId> seq, SQLIdentifiers.Quoter quoter) {
        super(seq, quoter);
    }

    private void parse() {
        this.startOffset = this.seq.offset();
        block14: do {
            switch (this.context) {
                case START: {
                    if (!SQLStatementAnalyzer.isKeyword("UPDATE", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.UPDATE);
                    break;
                }
                case UPDATE: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case IDENTIFIER: {
                            SQLStatementAnalyzer.TableIdent tableIdent = this.parseTableIdent();
                            if (tableIdent == null) break;
                            this.tables.add(tableIdent);
                            break;
                        }
                        case KEYWORD: {
                            if (SQLStatementAnalyzer.isKeyword("SET", (TokenSequence<SQLTokenId>)this.seq)) {
                                this.moveToContext(SQLStatement.Context.SET);
                                break;
                            }
                            if (!SQLStatementAnalyzer.isKeyword("ON", (TokenSequence<SQLTokenId>)this.seq)) break;
                            this.moveToContext(SQLStatement.Context.JOIN_CONDITION);
                        }
                    }
                    continue block14;
                }
                case JOIN_CONDITION: {
                    switch ((SQLTokenId)this.seq.token().id()) {
                        case COMMA: {
                            this.moveToContext(SQLStatement.Context.UPDATE);
                            break;
                        }
                        case KEYWORD: {
                            if (SQLStatementAnalyzer.isKeyword("JOIN", (TokenSequence<SQLTokenId>)this.seq)) {
                                this.moveToContext(SQLStatement.Context.UPDATE);
                                break;
                            }
                            if (!SQLStatementAnalyzer.isKeyword("SET", (TokenSequence<SQLTokenId>)this.seq)) break;
                            this.moveToContext(SQLStatement.Context.SET);
                        }
                    }
                    continue block14;
                }
                case SET: {
                    if (!SQLStatementAnalyzer.isKeyword("WHERE", (TokenSequence<SQLTokenId>)this.seq)) break;
                    this.moveToContext(SQLStatement.Context.WHERE);
                    break;
                }
            }
        } while (this.nextToken());
    }
}

