/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.neon.completion;

import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.languages.neon.completion.CompletionProviders;
import org.netbeans.modules.languages.neon.completion.CompletionUtils;
import org.netbeans.modules.languages.neon.completion.NeonCompletionHandler;
import org.netbeans.modules.languages.neon.completion.NeonCompletionProposal;
import org.netbeans.modules.languages.neon.completion.NeonElement;
import org.netbeans.modules.languages.neon.spi.completion.MethodCompletionProvider;
import org.netbeans.modules.php.spi.templates.completion.CompletionProvider;
import org.openide.filesystems.FileObject;

public enum NeonCompletionContext {
    ALL{

        @Override
        public void complete(List<CompletionProposal> completionProposals, NeonCompletionProposal.CompletionRequest request) {
            this.completeServiceConfigOpts(completionProposals, request);
            this.completeTypes(completionProposals, request);
            this.completeMethods(completionProposals, request);
        }
    }
    ,
    SERVICE_CONFIG_OPTS{

        @Override
        public void complete(List<CompletionProposal> completionProposals, NeonCompletionProposal.CompletionRequest request) {
            this.completeServiceConfigOpts(completionProposals, request);
        }
    }
    ,
    TYPES{

        @Override
        public void complete(List<CompletionProposal> completionProposals, NeonCompletionProposal.CompletionRequest request) {
            this.completeTypes(completionProposals, request);
        }
    }
    ,
    METHODS{

        @Override
        public void complete(List<CompletionProposal> completionProposals, NeonCompletionProposal.CompletionRequest request) {
            this.completeMethods(completionProposals, request);
        }
    };


    protected void completeServiceConfigOpts(List<CompletionProposal> completionProposals, NeonCompletionProposal.CompletionRequest request) {
        for (NeonElement serviceConfigOpts : NeonCompletionHandler.SERVICE_CONFIG_OPTS) {
            if (!CompletionUtils.startsWith(serviceConfigOpts.getName(), request.prefix)) continue;
            completionProposals.add(new NeonCompletionProposal.ServiceConfigOptCompletionProposal(serviceConfigOpts, request));
        }
    }

    protected void completeTypes(List<CompletionProposal> completionProposals, NeonCompletionProposal.CompletionRequest request) {
        List<CompletionProvider> typeCompletionProviders = CompletionProviders.getTypeProviders();
        FileObject fileObject = request.parserResult.getSnapshot().getSource().getFileObject();
        for (CompletionProvider typeCompletionProvider : typeCompletionProviders) {
            Set types = typeCompletionProvider.getItems(fileObject, request.prefix);
            for (String typeName : types) {
                completionProposals.add(new NeonCompletionProposal.TypeCompletionProposal(NeonElement.Factory.createType(typeName), request));
            }
        }
    }

    protected void completeMethods(List<CompletionProposal> completionProposals, NeonCompletionProposal.CompletionRequest request) {
        List<MethodCompletionProvider> methodCompletionProviders = CompletionProviders.getMethodProviders();
        FileObject fileObject = request.parserResult.getSnapshot().getSource().getFileObject();
        String typeName = CompletionUtils.extractTypeName(request.prefix);
        String methodPrefix = CompletionUtils.extractMethodPrefix(request.prefix);
        for (MethodCompletionProvider methodCompletionProvider : methodCompletionProviders) {
            Set<String> methods = methodCompletionProvider.complete(methodPrefix, typeName, fileObject);
            for (String methodName : methods) {
                completionProposals.add(new NeonCompletionProposal.MethodCompletionProposal(NeonElement.Factory.createMethod(methodName, typeName), request));
            }
        }
    }

    public abstract void complete(List<CompletionProposal> var1, NeonCompletionProposal.CompletionRequest var2);
}

