/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.jpa.dao;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.session.SessionEJBWizardPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupUISupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class EjbFacadeVisualPanel2
extends JPanel
implements DocumentListener {
    private final String CLASSNAME_LOCAL = NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_GeneratedFacadeLocal");
    private final String CLASSNAME_REMOTE = NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_GeneratedFacadeRemote");
    private WizardDescriptor wizard;
    private Project project;
    private JTextField packageComboBoxEditor;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private ComboBoxModel projectsList;
    private JTextField createdFilesText;
    private JComboBox inProjectCombo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JCheckBox localCheckBox;
    private JComboBox locationComboBox;
    private JComboBox packageComboBox;
    private JTextField projectTextField;
    private JCheckBox remoteCheckBox;

    public EjbFacadeVisualPanel2(Project project, WizardDescriptor wizard) {
        this.wizard = wizard;
        this.project = project;
        this.initComponents();
        this.packageComboBoxEditor = (JTextField)this.packageComboBox.getEditor().getEditorComponent();
        this.packageComboBoxEditor.getDocument().addDocumentListener(this);
        this.handleCheckboxes();
        J2eeProjectCapabilities projectCap = J2eeProjectCapabilities.forProject((Project)project);
        if (projectCap.isEjb31LiteSupported()) {
            boolean serverSupportsEJB31;
            boolean bl = serverSupportsEJB31 = ProjectUtil.getSupportedProfiles((Project)project).contains(Profile.JAVA_EE_6_FULL) || ProjectUtil.getSupportedProfiles((Project)project).contains(Profile.JAVA_EE_7_FULL);
            if (!projectCap.isEjb31Supported() && !serverSupportsEJB31) {
                this.remoteCheckBox.setVisible(false);
                this.remoteCheckBox.setEnabled(false);
            }
        } else {
            this.localCheckBox.setSelected(true);
        }
        this.updateInProjectCombo(false);
    }

    private void updateInProjectCombo(boolean show) {
        if (show) {
            this.remoteCheckBox.setText(NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Remote_In_Project"));
        } else {
            this.remoteCheckBox.setText(NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Remote"));
        }
        this.inProjectCombo.setVisible(show);
        if (show && this.projectsList == null) {
            List<Project> projects = SessionEJBWizardPanel.getProjectsList(this.project);
            this.projectsList = new DefaultComboBoxModel<Project>(projects.toArray(new Project[projects.size()]));
            final ListCellRenderer defaultRenderer = this.inProjectCombo.getRenderer();
            if (!projects.isEmpty()) {
                this.inProjectCombo.setRenderer(new ListCellRenderer(){

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        String name = ProjectUtils.getInformation((Project)((Project)value)).getDisplayName();
                        return defaultRenderer.getListCellRendererComponent(list, name, index, isSelected, cellHasFocus);
                    }
                });
                this.inProjectCombo.setModel(this.projectsList);
                this.inProjectCombo.setSelectedIndex(0);
            }
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_GeneratedSessionBeans");
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    boolean valid(WizardDescriptor wizard) {
        return true;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackage() {
        return this.packageComboBoxEditor.getText();
    }

    void read(WizardDescriptor settings) {
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)settings);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        SourceGroup[] sourceGroups = SourceGroups.getJavaSourceGroups((Project)this.project);
        if (sourceGroups.length > 0) {
            SourceGroup targetSourceGroup;
            SourceGroupUISupport.connect((JComboBox)this.locationComboBox, (SourceGroup[])sourceGroups);
            this.packageComboBox.setRenderer(PackageView.listRenderer());
            this.updateSourceGroupPackages();
            SourceGroup sourceGroup = targetSourceGroup = targetFolder != null ? SourceGroups.getFolderSourceGroup((SourceGroup[])sourceGroups, (FileObject)targetFolder) : sourceGroups[0];
            if (targetSourceGroup != null) {
                String targetPackage;
                this.locationComboBox.setSelectedItem(targetSourceGroup);
                if (targetFolder != null && (targetPackage = SourceGroups.getPackageForFolder((SourceGroup)targetSourceGroup, (FileObject)targetFolder)) != null) {
                    this.packageComboBoxEditor.setText(targetPackage);
                }
            }
            this.updateCheckboxes();
        }
    }

    void store(WizardDescriptor settings) {
        SourceGroup srcGroup = this.getLocationValue();
        if (srcGroup != null) {
            try {
                Templates.setTargetFolder((WizardDescriptor)settings, (FileObject)SourceGroups.getFolderForPackage((SourceGroup)srcGroup, (String)this.getPackage()));
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
        }
    }

    private void updateSourceGroupPackages() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel model = PackageView.createListView((SourceGroup)sourceGroup);
            if (model.getSelectedItem() != null && model.getSelectedItem().toString().startsWith("META-INF") && model.getSize() > 1) {
                model.setSelectedItem(model.getElementAt(1));
            }
            this.packageComboBox.setModel(model);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.fireUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.fireUpdate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.fireUpdate();
    }

    private void fireUpdate() {
        this.changeSupport.fireChange();
    }

    boolean isRemote() {
        return this.remoteCheckBox.isSelected();
    }

    boolean isLocal() {
        return this.localCheckBox.isSelected();
    }

    private void handleCheckboxes() {
        this.createdFilesText.setText(NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_CreatedFIles", (Object)(this.isLocal() ? ", " + this.CLASSNAME_LOCAL : ""), (Object)(this.isRemote() ? ", " + this.CLASSNAME_REMOTE : "")));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageComboBox = new JComboBox();
        this.projectTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.remoteCheckBox = new JCheckBox();
        this.localCheckBox = new JCheckBox();
        this.createdFilesText = new JTextField();
        this.jLabel5 = new JLabel();
        this.inProjectCombo = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_SpecifyLocation"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Project"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Location"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        this.projectTextField.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_CreateInterface"));
        Mnemonics.setLocalizedText((AbstractButton)this.remoteCheckBox, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Remote_In_Project"));
        this.remoteCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EjbFacadeVisualPanel2.this.remoteCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.localCheckBox, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_Local"));
        this.localCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.localCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EjbFacadeVisualPanel2.this.localCheckBoxActionPerformed(evt);
            }
        });
        this.createdFilesText.setEditable(false);
        this.createdFilesText.setHorizontalAlignment(2);
        this.createdFilesText.setText(NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_CreatedFIles", (Object[])new Object[]{"", ""}));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(EjbFacadeVisualPanel2.class, (String)"LBL_CreatedFilesLabel"));
        this.inProjectCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EjbFacadeVisualPanel2.this.inProjectComboActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectTextField, -1, 585, Short.MAX_VALUE).addComponent(this.locationComboBox, 0, 585, Short.MAX_VALUE).addComponent(this.packageComboBox, 0, 585, Short.MAX_VALUE).addComponent(this.createdFilesText, -1, 585, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.remoteCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inProjectCombo, 0, 521, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel6).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.localCheckBox))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.projectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.locationComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.packageComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.createdFilesText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.remoteCheckBox).addComponent(this.inProjectCombo, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void localCheckBoxActionPerformed(ActionEvent evt) {
        this.handleCheckboxes();
        this.changeSupport.fireChange();
    }

    private void remoteCheckBoxActionPerformed(ActionEvent evt) {
        this.handleCheckboxes();
        this.updateInProjectCombo(this.remoteCheckBox.isSelected());
        this.changeSupport.fireChange();
    }

    private void inProjectComboActionPerformed(ActionEvent evt) {
        this.changeSupport.fireChange();
    }

    private void updateCheckboxes() {
        this.localCheckBox.setSelected(!J2eeProjectCapabilities.forProject((Project)this.project).isEjb31LiteSupported());
        this.changeSupport.fireChange();
    }

    public Project getRemoteInterfaceProject() {
        if (this.projectsList == null) {
            return null;
        }
        return (Project)this.projectsList.getSelectedItem();
    }
}

