/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient.api;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProvider;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProviders;
import org.netbeans.modules.selenium2.webclient.api.TestRunnerReporter;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProvider;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProviders;
import org.netbeans.modules.web.clientproject.api.jstesting.TestRunInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;

public final class SeleniumRerunHandler
implements RerunHandler {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static final RequestProcessor RP = new RequestProcessor(SeleniumRerunHandler.class.getName(), 1);
    private volatile boolean enabled = true;
    private final FileObject[] activatedFOs;
    private final Project project;
    private final boolean isSelenium;
    private final String identifier;

    public SeleniumRerunHandler(Project project, FileObject[] activatedFOs, String identifier, boolean isSelenium) {
        this.project = project;
        this.activatedFOs = activatedFOs;
        this.isSelenium = isSelenium;
        this.identifier = identifier;
    }

    public void rerun() {
        this.setEnabled(false);
        this.runTests(this.activatedFOs);
        this.setEnabled(true);
    }

    public void rerun(Set<Testcase> tests) {
        this.setEnabled(false);
        ArrayList<FileObject> tests2run = new ArrayList<FileObject>();
        block0: for (Testcase testcase : tests) {
            testcase.getTrouble().getStackTrace();
            TestRunnerReporter.CallStackCallback callStackCallback = new TestRunnerReporter.CallStackCallback(this.project);
            for (String callstackFrameInfo : testcase.getTrouble().getStackTrace()) {
                FileObject fo;
                Pair<File, int[]> pair = callStackCallback.parseLocation(callstackFrameInfo, true);
                if (pair == null || tests2run.contains(fo = FileUtil.toFileObject((File)((File)pair.first())))) continue;
                tests2run.add(fo);
                continue block0;
            }
        }
        if (!tests2run.isEmpty()) {
            this.runTests(tests2run.toArray(new FileObject[tests2run.size()]));
        }
        this.setEnabled(true);
    }

    private void runTests(final FileObject[] testFOs) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Project p = FileOwnerQuery.getOwner((FileObject)testFOs[0]);
                if (p == null) {
                    return;
                }
                if (SeleniumRerunHandler.this.isSelenium) {
                    SeleniumTestingProvider provider = SeleniumTestingProviders.getDefault().findSeleniumTestingProvider(SeleniumRerunHandler.this.identifier);
                    if (provider != null) {
                        provider.runTests(testFOs);
                    }
                } else {
                    JsTestingProvider provider = JsTestingProviders.getDefault().findJsTestingProvider(SeleniumRerunHandler.this.identifier);
                    if (provider != null) {
                        provider.runTests(SeleniumRerunHandler.this.project, new TestRunInfo.Builder().setSessionType(TestRunInfo.SessionType.TEST).setTestFile(null).build());
                    }
                }
            }
        });
    }

    public boolean enabled(RerunType type) {
        switch (type) {
            case ALL: {
                return this.enabled;
            }
            case CUSTOM: {
                return this.enabled;
            }
        }
        assert (false) : "Unknown rerun type: " + type;
        return false;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void setEnabled(boolean newEnabled) {
        if (this.enabled != newEnabled) {
            this.enabled = newEnabled;
            this.changeSupport.fireChange();
        }
    }
}

