/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.classpath.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.spi.java.classpath.FlaggedClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

final class MuxClassPathImplementation
implements FlaggedClassPathImplementation,
PropertyChangeListener {
    private final ClassPathSupport.Selector selector;
    private final PropertyChangeSupport listeners;
    private List<PathResourceImplementation> cache;
    private Set<ClassPath.Flag> flagsCache;
    private boolean activeClassPathValid;
    private ClassPath activeClassPath;
    private PropertyChangeListener activeListener;

    MuxClassPathImplementation(@NonNull ClassPathSupport.Selector selector) {
        Parameters.notNull((CharSequence)"selector", (Object)selector);
        this.listeners = new PropertyChangeSupport(this);
        this.selector = selector;
        this.selector.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.selector));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Set<ClassPath.Flag> getFlags() {
        Set<ClassPath.Flag> res;
        MuxClassPathImplementation muxClassPathImplementation = this;
        synchronized (muxClassPathImplementation) {
            res = this.flagsCache;
        }
        if (res == null) {
            res = this.getActiveClassPath().getFlags();
            assert (res != null);
            muxClassPathImplementation = this;
            synchronized (muxClassPathImplementation) {
                if (this.flagsCache == null) {
                    this.flagsCache = res;
                } else {
                    res = this.flagsCache;
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public List<? extends PathResourceImplementation> getResources() {
        List<PathResourceImplementation> res;
        MuxClassPathImplementation muxClassPathImplementation = this;
        synchronized (muxClassPathImplementation) {
            res = this.cache;
        }
        if (res == null) {
            ClassPath cp = this.getActiveClassPath();
            List<ClassPath.Entry> entries = cp.entries();
            res = new ArrayList<PathResourceImplementation>(entries.size());
            for (ClassPath.Entry entry : entries) {
                res.add(ClassPathSupport.createResource(entry.getURL()));
            }
            MuxClassPathImplementation muxClassPathImplementation2 = this;
            synchronized (muxClassPathImplementation2) {
                if (this.cache == null) {
                    this.cache = Collections.unmodifiableList(res);
                } else {
                    res = this.cache;
                }
            }
        }
        return res;
    }

    @Override
    public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("activeClassPath".equals(propName)) {
            MuxClassPathImplementation muxClassPathImplementation = this;
            synchronized (muxClassPathImplementation) {
                this.cache = null;
                this.flagsCache = null;
                this.activeClassPathValid = false;
            }
            this.listeners.firePropertyChange("resources", null, null);
            this.listeners.firePropertyChange("flags", null, null);
        } else if ("entries".equals(propName)) {
            MuxClassPathImplementation muxClassPathImplementation = this;
            synchronized (muxClassPathImplementation) {
                this.cache = null;
            }
            this.listeners.firePropertyChange("resources", null, null);
        } else if ("flags".equals(propName)) {
            MuxClassPathImplementation muxClassPathImplementation = this;
            synchronized (muxClassPathImplementation) {
                this.flagsCache = null;
            }
            this.listeners.firePropertyChange("flags", null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private ClassPath getActiveClassPath() {
        MuxClassPathImplementation muxClassPathImplementation = this;
        synchronized (muxClassPathImplementation) {
            if (this.activeClassPathValid) {
                assert (this.activeClassPath != null);
                return this.activeClassPath;
            }
            if (this.activeClassPath != null) {
                assert (this.activeListener != null);
                this.activeClassPath.removePropertyChangeListener(this.activeListener);
                this.activeClassPath = null;
                this.activeListener = null;
            }
        }
        ClassPath newCp = this.selector.getActiveClassPath();
        assert (newCp != null) : String.format("Selector: %s (%s) returned null ClassPath", this.selector, this.selector.getClass());
        MuxClassPathImplementation muxClassPathImplementation2 = this;
        synchronized (muxClassPathImplementation2) {
            if (this.activeClassPath == null) {
                assert (this.activeListener == null);
                this.activeClassPath = newCp;
                this.activeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.activeClassPath);
                this.activeClassPath.addPropertyChangeListener(this.activeListener);
                this.activeClassPathValid = true;
            }
            return this.activeClassPath;
        }
    }
}

