/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractAction;
import javax.xml.soap.SOAPMessage;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.Utils;
import org.netbeans.modules.websvc.design.view.widget.AbstractTitledWidget;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.EditorPaneWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;
import org.openide.util.NbBundle;

public class SampleMessageWidget
extends AbstractTitledWidget {
    private static final Color INPUT_COLOR = new Color(128, 128, 255);
    private static final Color OUTPUT_COLOR = new Color(102, 204, 102);
    private transient Widget buttons;
    private transient ImageLabelWidget headerLabelWidget;
    private transient EditorPaneWidget paneWidget;
    private MethodModel operation;
    private Type type;

    public SampleMessageWidget(ObjectScene scene, MethodModel operation, Type type) {
        super(scene, 0, 12, 0, TITLE_COLOR);
        this.operation = operation;
        this.type = type;
        this.headerLabelWidget = new ImageLabelWidget((Scene)scene, null, operation.getOperationName() + ": ", type.getTitle());
        this.headerLabelWidget.setLabelFont(scene.getFont().deriveFont(1));
        this.headerLabelWidget.setPaintAsDisabled(false);
        this.headerLabelWidget.setLabelForeground(type.getBorderColor());
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)1);
        this.getHeaderWidget().addChild((Widget)this.headerLabelWidget);
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)1);
        this.buttons = new Widget(this.getScene());
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)8));
        this.getHeaderWidget().addChild(this.buttons);
        ButtonWidget closeButton = new ButtonWidget(this.getScene(), (String)null);
        closeButton.setImage(new ExpanderImageWidget((Scene)scene, type.getBorderColor(), 8));
        closeButton.setRoundedBorder(0, 4, 4, type.getBorderColor());
        closeButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SampleMessageWidget.this.removeFromParent();
            }
        });
        this.buttons.addChild((Widget)closeButton);
        this.paneWidget = new EditorPaneWidget((Scene)scene, Utils.getFormatedDocument(type.getMessage(operation)), "text/xml");
        this.paneWidget.setEditable(false);
        this.getContentWidget().addChild((Widget)this.paneWidget);
        this.getContentWidget().setBorder(BorderFactory.createEmptyBorder((int)12, (int)6));
    }

    private static class ButtonImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        private boolean isInput;

        public ButtonImageWidget(Scene scene, int size, Color color, boolean input) {
            super(scene, color, size, size);
            this.isInput = input;
        }

        @Override
        protected Shape createImage(int width, int height) {
            GeneralPath path = new GeneralPath();
            int arrowWidth = height / 3;
            float x1 = this.isInput ? 0.0f : (float)width;
            float x2 = this.isInput ? (float)(3 * width) / 4.0f : (float)width / 4.0f;
            float gap = (float)(width - arrowWidth) / 2.0f;
            path.moveTo(x1, gap);
            path.lineTo((float)width / 2.0f, gap);
            path.lineTo((float)width / 2.0f, (float)height / 2.0f - (float)arrowWidth);
            path.lineTo(x2, height / 2);
            path.lineTo((float)width / 2.0f, (float)height / 2.0f + (float)arrowWidth);
            path.lineTo((float)width / 2.0f, gap + (float)arrowWidth);
            path.lineTo(x1, gap + (float)arrowWidth);
            path.closePath();
            path.moveTo((float)width / 2.0f, (float)height / 8.0f - 1.0f);
            path.lineTo((float)width - x1, (float)height / 8.0f - 1.0f);
            path.moveTo((float)width / 2.0f, (float)(7 * height) / 8.0f + 1.0f);
            path.lineTo((float)width - x1, (float)(7 * height) / 8.0f + 1.0f);
            path.moveTo(x2, (float)height / 4.0f);
            path.lineTo((float)width - x1, (float)height / 4.0f);
            path.moveTo(x2, (float)(3 * height) / 4.0f);
            path.lineTo((float)width - x1, (float)(3 * height) / 4.0f);
            path.moveTo(this.isInput ? (float)(7 * width) / 8.0f : (float)width / 8.0f, (float)height / 2.0f);
            path.lineTo((float)width - x1, (float)height / 2.0f);
            return path;
        }

        @Override
        protected void paintWidget() {
            Rectangle bounds = this.getImage().getBounds();
            Graphics2D gr = this.getGraphics();
            Paint oldPaint = gr.getPaint();
            gr.setPaint(new GradientPaint(0.0f, bounds.y + bounds.height / 6, this.getForeground().brighter().brighter(), 0.0f, bounds.y + bounds.height / 2, this.getForeground().brighter(), true));
            gr.fill(this.getImage());
            gr.setPaint(oldPaint);
            super.paintWidget();
        }
    }

    private static class ExpanderImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        private static final Stroke STROKE = new BasicStroke(2.5f, 2, 0);

        public ExpanderImageWidget(Scene scene, Color color, int size) {
            super(scene, color, size, size);
        }

        @Override
        protected Stroke getImageStroke() {
            return STROKE;
        }

        @Override
        protected Shape createImage(int width, int height) {
            GeneralPath path = new GeneralPath();
            path.moveTo(0.0f, 0.0f);
            path.lineTo(width, height);
            path.moveTo(0.0f, height);
            path.lineTo(width, 0.0f);
            return path;
        }
    }

    public static enum Type {
        INPUT{

            @Override
            public ButtonImageWidget getIcon(Scene scene) {
                return new ButtonImageWidget(scene, 16, this.getBorderColor(), true);
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(SampleMessageWidget.class, (String)"Hint_SampleInput");
            }

            @Override
            String getTitle() {
                return NbBundle.getMessage(SampleMessageWidget.class, (String)"TITLE_SampleInput");
            }

            @Override
            Color getBorderColor() {
                return INPUT_COLOR;
            }

            @Override
            SOAPMessage getMessage(MethodModel operation) {
                return operation.getSoapRequest();
            }
        }
        ,
        OUTPUT{

            @Override
            public ButtonImageWidget getIcon(Scene scene) {
                return new ButtonImageWidget(scene, 16, this.getBorderColor(), false);
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(SampleMessageWidget.class, (String)"Hint_SampleOutput");
            }

            @Override
            String getTitle() {
                return NbBundle.getMessage(SampleMessageWidget.class, (String)"TITLE_SampleOutput");
            }

            @Override
            Color getBorderColor() {
                return OUTPUT_COLOR;
            }

            @Override
            SOAPMessage getMessage(MethodModel operation) {
                return operation.getSoapResponse();
            }
        };


        public abstract ButtonImageWidget getIcon(Scene var1);

        public abstract String getDescription();

        abstract String getTitle();

        abstract Color getBorderColor();

        abstract SOAPMessage getMessage(MethodModel var1);
    }
}

