# -*- coding: binary -*-
require 'rex/proto/ntlm/constants'
require 'rex/proto/ntlm/crypt'
require 'rex/proto/ntlm/base'
require 'rex/proto/ntlm/message'
require 'rex/proto/ntlm/utils'

NTLM_CONST   ||= ::Rex::Proto::NTLM::Constants
NTLM_CRYPT   ||= ::Rex::Proto::NTLM::Crypt
NTLM_UTILS   ||= ::Rex::Proto::NTLM::Utils
NTLM_BASE    ||= ::Rex::Proto::NTLM::Base
NTLM_MESSAGE ||= ::Rex::Proto::NTLM::Message

module Msf

###
#
# This mixins will only provide the options name and description when a protocol want to use ntlm features from lib/rex/proto/ntlm .
# Unfortunately other mixin's still have to make direct call from lib/rex/proto/ntlm
# cause some protocol like SMB are implemented in lib/rex/proto/ while others like mssql are implemented in lib/msf/core/exploit
#
###

module Exploit::NTLM

  module Client
    def initialize(info = {})
      super
      register_advanced_options(
      [
      #
      # UseNTLMv2 forces NTLMv2 instead of NTLM2_session behavior when the 'Negotiate NTLM2' flag is set
      #
      OptBool.new('NTLM::UseNTLMv2', [ true, "Use NTLMv2 instead of NTLM2_session when \'Negotiate NTLM2\' key is true", true]),
      #
      # UseNTLM2_session forces the use of NTLMV2 session keys instead of NTLMv1, emulating the default of Windows 2000+
      #
      OptBool.new('NTLM::UseNTLM2_session', [ true, 'Activate the \'Negotiate NTLM2 key\' flag, forcing the use of a NTLMv2_session', true]),
      #
      # SendLM has no effect when NTLM_UseNTLM2_session = true, NTLM_UseNTLMv2 = false or NTLM_SendNTLM = false
      #
      OptBool.new('NTLM::SendLM', [ true, "Always send the LANMAN response (except when NTLMv2_session is specified)", true]),
      #
      # UseLMKey is valid when NTLM_SendLM = true, NTLM_SendNTLM = true, or NTLM_UseNTLM2_session = false
      #
      OptBool.new('NTLM::UseLMKey', [ true, "Activate the \'Negotiate Lan Manager Key\' flag, using the LM key when the LM response is sent", false]),
      #
      # SendNTLM allows the NTLM response to be excluded, emulating Win9x behavior (don't change unless you are testing)
      #
      OptBool.new('NTLM::SendNTLM', [ true, 'Activate the \'Negotiate NTLM key\' flag, indicating the use of NTLM responses', true]),
      #
      # SendSPN will send an avp of type 9/SPN in the ntlmv2 client blob, this is mandatory on windows seven / 2008 r2 if
      # Microsoft network server : Server SPN target name validation level is set to <Required from client> or we get an STATUS_ACCESS_DENIED
      #
      OptBool.new('NTLM::SendSPN', [ true, 'Send an avp of type SPN in the ntlmv2 client blob, this allows authentication on Windows 7+/Server 2008 R2+ when SPN is required', true]),
      ], Msf::Exploit::NTLM::Client)
    end
  end

=begin
  module Server
    def initialize(info = {})
      super
      register_options(
      [

      ], Msf::Exploit::NTLM::Server)
    end
  end
=end

end

end

