/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.JsLibrary;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J$\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0002J$\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0002J$\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0002J*\u0010\u001e\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0007J$\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0007J\u000e\u0010\"\u001a\u0004\u0018\u00010\u0006*\u00020\nH\u0002J\f\u0010#\u001a\u00020\n*\u00020\nH\u0002J(\u0010$\u001a\u00020\b*\u00020\n2\u0006\u0010%\u001a\u00020\u00062\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/utils/JsLibraryUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "META_INF_RESOURCES", "", "copyJsFilesFromDirectory", "", "dir", "Ljava/io/File;", "outputLibraryJsPath", "copySourceMap", "", "copyJsFilesFromLibraries", "libraries", "", "copyJsFilesFromZip", "file", "copyLibrary", "outputPath", "library", "Lorg/jetbrains/kotlin/utils/JsLibrary;", "getSuggestedPath", "path", "processDirectory", "action", "Lkotlin/Function1;", "traverseArchive", "traverseDirectory", "traverseJsLibraries", "libs", "traverseJsLibrary", "lib", "contentIfExists", "correspondingSourceMapFile", "runIfFileExists", "relativePath", "util"})
public final class JsLibraryUtils {
    private static final Logger LOG;
    private static final String META_INF_RESOURCES = "META-INF/resources/";
    public static final JsLibraryUtils INSTANCE;

    @JvmStatic
    public static final void copyJsFilesFromLibraries(@NotNull List<String> libraries, @NotNull String outputLibraryJsPath, boolean copySourceMap) {
        Intrinsics.checkParameterIsNotNull(libraries, "libraries");
        Intrinsics.checkParameterIsNotNull(outputLibraryJsPath, "outputLibraryJsPath");
        for (String library : libraries) {
            File file2 = new File(library);
            boolean bl = file2.exists();
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Library " + library + " not found";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (file2.isDirectory()) {
                INSTANCE.copyJsFilesFromDirectory(file2, outputLibraryJsPath, copySourceMap);
                continue;
            }
            INSTANCE.copyJsFilesFromZip(file2, outputLibraryJsPath, copySourceMap);
        }
    }

    public static /* synthetic */ void copyJsFilesFromLibraries$default(List list2, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        JsLibraryUtils.copyJsFilesFromLibraries(list2, string, bl);
    }

    @JvmStatic
    public static final void traverseJsLibraries(@NotNull List<? extends File> libs, @NotNull Function1<? super JsLibrary, Unit> action) {
        Intrinsics.checkParameterIsNotNull(libs, "libs");
        Intrinsics.checkParameterIsNotNull(action, "action");
        Iterable $this$forEach$iv = libs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            JsLibraryUtils.traverseJsLibrary(it, action);
        }
    }

    @JvmStatic
    public static final void traverseJsLibrary(@NotNull File lib, @NotNull Function1<? super JsLibrary, Unit> action) {
        block2: {
            File jsFile;
            block3: {
                block1: {
                    Intrinsics.checkParameterIsNotNull(lib, "lib");
                    Intrinsics.checkParameterIsNotNull(action, "action");
                    if (!lib.isDirectory()) break block1;
                    INSTANCE.traverseDirectory(lib, action);
                    break block2;
                }
                if (!FileUtil.isJarOrZip(lib)) break block3;
                INSTANCE.traverseArchive(lib, action);
                break block2;
            }
            String string = lib.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "lib.name");
            if (!StringsKt.endsWith$default(string, ".js", false, 2, null)) break block2;
            String string2 = lib.getPath();
            Intrinsics.checkExpressionValueIsNotNull(string2, "lib.path");
            INSTANCE.runIfFileExists(lib, string2, action);
            File file2 = jsFile = FileUtilsKt.withReplacedExtensionOrNull(lib, ".meta.js", ".js");
            if (file2 != null) {
                String string3 = jsFile.getPath();
                Intrinsics.checkExpressionValueIsNotNull(string3, "jsFile.path");
                INSTANCE.runIfFileExists(file2, string3, action);
            }
        }
    }

    private final void runIfFileExists(@NotNull File $this$runIfFileExists, String relativePath, Function1<? super JsLibrary, Unit> action) {
        if ($this$runIfFileExists.isFile()) {
            action.invoke(new JsLibrary(FilesKt.readText$default($this$runIfFileExists, null, 1, null), relativePath, this.contentIfExists(this.correspondingSourceMapFile($this$runIfFileExists)), $this$runIfFileExists));
        }
    }

    private final void copyJsFilesFromDirectory(File dir, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseDirectory(dir, (Function1<? super JsLibrary, Unit>)new Function1<JsLibrary, Unit>(outputLibraryJsPath, copySourceMap){
            final /* synthetic */ String $outputLibraryJsPath;
            final /* synthetic */ boolean $copySourceMap;

            public final void invoke(@NotNull JsLibrary it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                JsLibraryUtils.access$copyLibrary(JsLibraryUtils.INSTANCE, this.$outputLibraryJsPath, it, this.$copySourceMap);
            }
            {
                this.$outputLibraryJsPath = string;
                this.$copySourceMap = bl;
                super(1);
            }
        });
    }

    private final String contentIfExists(@NotNull File $this$contentIfExists) {
        return $this$contentIfExists.exists() ? FilesKt.readText$default($this$contentIfExists, null, 1, null) : null;
    }

    private final File correspondingSourceMapFile(@NotNull File $this$correspondingSourceMapFile) {
        return new File($this$correspondingSourceMapFile.getParentFile(), $this$correspondingSourceMapFile.getName() + ".map");
    }

    private final void processDirectory(File dir, Function1<? super JsLibrary, Unit> action) {
        FileUtil.processFilesRecursively(dir, (Processor<? super File>)new Processor<File>(dir, action){
            final /* synthetic */ File $dir;
            final /* synthetic */ Function1 $action;

            public final boolean process(File file2) {
                String string = FileUtil.getRelativePath(this.$dir, file2);
                if (string == null) {
                    throw (Throwable)new IllegalArgumentException("relativePath should not be null " + this.$dir + ' ' + file2);
                }
                Intrinsics.checkExpressionValueIsNotNull(string, "FileUtil.getRelativePath\u2026 not be null $dir $file\")");
                String relativePath = string;
                if (StringsKt.endsWith$default(relativePath, ".js", false, 2, null)) {
                    String string2 = JsLibraryUtils.access$getSuggestedPath(JsLibraryUtils.INSTANCE, relativePath);
                    if (string2 == null) {
                        return true;
                    }
                    String suggestedRelativePath = string2;
                    File file3 = file2;
                    Intrinsics.checkExpressionValueIsNotNull(file3, "file");
                    JsLibraryUtils.access$runIfFileExists(JsLibraryUtils.INSTANCE, file3, suggestedRelativePath, this.$action);
                }
                return true;
            }
            {
                this.$dir = file2;
                this.$action = function1;
            }
        });
    }

    private final void traverseDirectory(File dir, Function1<? super JsLibrary, Unit> action) {
        try {
            this.processDirectory(dir, action);
        }
        catch (IOException ex) {
            LOG.error("Could not read files from directory " + dir.getName() + ": " + ex.getMessage());
        }
    }

    private final void copyJsFilesFromZip(File file2, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseArchive(file2, (Function1<? super JsLibrary, Unit>)new Function1<JsLibrary, Unit>(outputLibraryJsPath, copySourceMap){
            final /* synthetic */ String $outputLibraryJsPath;
            final /* synthetic */ boolean $copySourceMap;

            public final void invoke(@NotNull JsLibrary it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                JsLibraryUtils.access$copyLibrary(JsLibraryUtils.INSTANCE, this.$outputLibraryJsPath, it, this.$copySourceMap);
            }
            {
                this.$outputLibraryJsPath = string;
                this.$copySourceMap = bl;
                super(1);
            }
        });
    }

    private final void copyLibrary(String outputPath, JsLibrary library, boolean copySourceMap) {
        block1: {
            File targetFile = new File(outputPath, library.getPath());
            targetFile.getParentFile().mkdirs();
            FilesKt.writeText$default(targetFile, library.getContent(), null, 2, null);
            if (!copySourceMap) break block1;
            String string = library.getSourceMapContent();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                FilesKt.writeText$default(new File(targetFile.getParent(), targetFile.getName() + ".map"), it, null, 2, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void traverseArchive(File file2, Function1<? super JsLibrary, Unit> action) {
        try (ZipFile zipFile2 = new ZipFile(file2.getPath());){
            void $this$mapTo$iv$iv;
            Object correspondingJsPath;
            Enumeration<? extends ZipEntry> zipEntries = zipFile2.entries();
            boolean bl = false;
            List librariesWithoutSourceMaps = new ArrayList();
            boolean bl2 = false;
            Map possibleMapFiles = new LinkedHashMap();
            while (zipEntries.hasMoreElements()) {
                ZipEntry entry;
                ZipEntry zipEntry = entry = zipEntries.nextElement();
                Intrinsics.checkExpressionValueIsNotNull(zipEntry, "entry");
                String entryName = zipEntry.getName();
                if (entry.isDirectory()) continue;
                String string = entryName;
                Intrinsics.checkExpressionValueIsNotNull(string, "entryName");
                if (StringsKt.endsWith$default(string, ".js", false, 2, null)) {
                    String relativePath;
                    String content;
                    if (this.getSuggestedPath(entryName) == null) {
                        continue;
                    }
                    InputStream stream2 = zipFile2.getInputStream(entry);
                    Intrinsics.checkExpressionValueIsNotNull(FileUtil.loadTextAndClose(stream2), "FileUtil.loadTextAndClose(stream)");
                    Collection collection = librariesWithoutSourceMaps;
                    JsLibrary jsLibrary = new JsLibrary(content, relativePath, null, null);
                    boolean bl3 = false;
                    collection.add(jsLibrary);
                    continue;
                }
                if (!StringsKt.endsWith$default(entryName, ".js.map", false, 2, null)) continue;
                correspondingJsPath = StringsKt.removeSuffix(entryName, (CharSequence)".js.map") + ".js";
                possibleMapFiles.put(correspondingJsPath, entry);
            }
            Iterable $this$map$iv = librariesWithoutSourceMaps;
            boolean $i$f$map = false;
            correspondingJsPath = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsLibrary jsLibrary;
                void it;
                JsLibrary jsLibrary2 = (JsLibrary)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                ZipEntry zipEntry = (ZipEntry)possibleMapFiles.get(it.getPath());
                if (zipEntry != null) {
                    String content;
                    InputStream stream3 = zipFile2.getInputStream(zipEntry);
                    Intrinsics.checkExpressionValueIsNotNull(FileUtil.loadTextAndClose(stream3), "FileUtil.loadTextAndClose(stream)");
                    jsLibrary = JsLibrary.copy$default((JsLibrary)it, null, null, content, null, 11, null);
                } else {
                    jsLibrary = it;
                }
                void var20_28 = jsLibrary;
                collection.add(var20_28);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                action.invoke((JsLibrary)element$iv);
            }
        }
    }

    private final String getSuggestedPath(String path2) {
        String string = FileUtil.toSystemIndependentName(path2);
        Intrinsics.checkExpressionValueIsNotNull(string, "FileUtil.toSystemIndependentName(path)");
        String systemIndependentPath = string;
        if (StringsKt.startsWith$default(systemIndependentPath, LibraryUtils.INSTANCE.getMETA_INF(), false, 2, null)) {
            if (StringsKt.startsWith$default(systemIndependentPath, META_INF_RESOURCES, false, 2, null)) {
                String string2 = path2;
                int n = META_INF_RESOURCES.length();
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).substring(startIndex)");
                return string4;
            }
            return null;
        }
        return path2;
    }

    private JsLibraryUtils() {
    }

    static {
        JsLibraryUtils jsLibraryUtils;
        INSTANCE = jsLibraryUtils = new JsLibraryUtils();
        Logger logger = Logger.getInstance(LibraryUtils.class);
        Intrinsics.checkExpressionValueIsNotNull(logger, "Logger.getInstance(LibraryUtils::class.java)");
        LOG = logger;
        META_INF_RESOURCES = LibraryUtils.INSTANCE.getMETA_INF() + "resources/";
    }

    public static final /* synthetic */ void access$copyLibrary(JsLibraryUtils $this, String outputPath, JsLibrary library, boolean copySourceMap) {
        $this.copyLibrary(outputPath, library, copySourceMap);
    }

    public static final /* synthetic */ String access$getSuggestedPath(JsLibraryUtils $this, String path2) {
        return $this.getSuggestedPath(path2);
    }

    public static final /* synthetic */ void access$runIfFileExists(JsLibraryUtils $this, File $this$access_u24runIfFileExists, String relativePath, Function1 action) {
        $this.runIfFileExists($this$access_u24runIfFileExists, relativePath, action);
    }
}

