#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: servant-swagger
version: 1.1.7.1
id: servant-swagger-1.1.7.1-6f9HFaUHCi8IQARNG2TG90
key: servant-swagger-1.1.7.1-6f9HFaUHCi8IQARNG2TG90
license: BSD-3-Clause
copyright: (c) 2015-2018, Servant contributors
maintainer: nickolay.kudasov@gmail.com
author: David Johnson, Nickolay Kudasov
homepage: https://github.com/haskell-servant/servant-swagger
synopsis: Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.
description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.
    .
    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.
    .
    Generated Swagger specification then can be used for many things such as
    .
    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);
    .
    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);
    .
    * and [many others](http://swagger.io/open-source-integrations/).
category: Web, Servant, Swagger
abi: 816a106a2786ed5832aa296927e45a2d
exposed: True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel
import-dirs: /usr/lib/ghc-8.6.5/site-local/servant-swagger-1.1.7.1
library-dirs: /usr/lib/ghc-8.6.5/site-local/servant-swagger-1.1.7.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/servant-swagger-1.1.7.1
hs-libraries: HSservant-swagger-1.1.7.1-6f9HFaUHCi8IQARNG2TG90
depends:
    QuickCheck-2.13.1-7krqagqcRmA9RWDtUhyOg8
    aeson-1.4.3.0-3QzK2ng22UC3SLyLfNCRqk
    aeson-pretty-0.8.7-JelIkFMl05IE97owceuwI5 base-4.12.0.0
    base-compat-0.10.5-FRXoAxOVtbG2qLNIZm1tTr bytestring-0.10.8.2
    hspec-2.7.1-BM9PaknplgV4aseUQQxUdn
    http-media-0.8.0.0-L25zQqkU26CA7yE3vl2O05
    insert-ordered-containers-0.2.2-CK1SucNMSTJ4d66enhfL6O
    lens-4.17.1-Dps0uj7PK1BKK4O2DnOjg0
    servant-0.16.1-1WOl2okur2yAsmqxXAkUKy
    singleton-bool-0.1.4-BswWCJ6C1foFLbVlo6nj0a
    swagger2-2.3.1.1-7ugbjPlVHu93T6AW9opdGx text-1.2.3.1
    unordered-containers-0.2.10.0-FCaPs5fnhYpFgvItTiMoQE
haddock-interfaces: /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock
haddock-html: /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

