/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.MaxAgeCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxDocsCondition;
import org.elasticsearch.action.admin.indices.rollover.MaxSizeCondition;
import org.elasticsearch.action.resync.TransportResyncReplicationAction;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.mapper.BaseGeoShapeFieldMapper;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.BooleanFieldMapper;
import org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.IdFieldMapper;
import org.elasticsearch.index.mapper.IgnoredFieldMapper;
import org.elasticsearch.index.mapper.IndexFieldMapper;
import org.elasticsearch.index.mapper.IpFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.elasticsearch.index.mapper.SeqNoFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TypeFieldMapper;
import org.elasticsearch.index.mapper.VersionFieldMapper;
import org.elasticsearch.index.seqno.GlobalCheckpointSyncAction;
import org.elasticsearch.index.shard.PrimaryReplicaSyncer;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.flush.SyncedFlushService;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;
import org.elasticsearch.plugins.MapperPlugin;

public class IndicesModule
extends AbstractModule {
    private final List<NamedWriteableRegistry.Entry> namedWritables = new ArrayList<NamedWriteableRegistry.Entry>();
    private final MapperRegistry mapperRegistry;
    private static final Map<String, MetadataFieldMapper.TypeParser> builtInMetadataMappers = IndicesModule.initBuiltInMetadataMappers();

    public IndicesModule(List<MapperPlugin> mapperPlugins) {
        this.mapperRegistry = new MapperRegistry(this.getMappers(mapperPlugins), IndicesModule.getMetadataMappers(mapperPlugins), IndicesModule.getFieldFilter(mapperPlugins));
        this.registerBuiltinWritables();
    }

    private void registerBuiltinWritables() {
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_age", MaxAgeCondition::new));
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_docs", MaxDocsCondition::new));
        this.namedWritables.add(new NamedWriteableRegistry.Entry(Condition.class, "max_size", MaxSizeCondition::new));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWritables;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContents() {
        return Arrays.asList(new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_age", new String[0]), (p, c) -> MaxAgeCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_docs", new String[0]), (p, c) -> MaxDocsCondition.fromXContent(p)), new NamedXContentRegistry.Entry(Condition.class, new ParseField("max_size", new String[0]), (p, c) -> MaxSizeCondition.fromXContent(p)));
    }

    private Map<String, Mapper.TypeParser> getMappers(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, Mapper.TypeParser> mappers = new LinkedHashMap<String, Mapper.TypeParser>();
        for (NumberFieldMapper.NumberType numberType : NumberFieldMapper.NumberType.values()) {
            mappers.put(numberType.typeName(), new NumberFieldMapper.TypeParser(numberType));
        }
        for (Enum enum_ : RangeFieldMapper.RangeType.values()) {
            mappers.put(((RangeFieldMapper.RangeType)enum_).typeName(), new RangeFieldMapper.TypeParser((RangeFieldMapper.RangeType)enum_));
        }
        mappers.put("boolean", new BooleanFieldMapper.TypeParser());
        mappers.put("binary", new BinaryFieldMapper.TypeParser());
        DateFieldMapper.Resolution milliseconds = DateFieldMapper.Resolution.MILLISECONDS;
        mappers.put(milliseconds.type(), new DateFieldMapper.TypeParser(milliseconds));
        DateFieldMapper.Resolution nanoseconds = DateFieldMapper.Resolution.NANOSECONDS;
        mappers.put(nanoseconds.type(), new DateFieldMapper.TypeParser(nanoseconds));
        mappers.put("ip", new IpFieldMapper.TypeParser());
        mappers.put("text", new TextFieldMapper.TypeParser());
        mappers.put("keyword", new KeywordFieldMapper.TypeParser());
        mappers.put("object", new ObjectMapper.TypeParser());
        mappers.put("nested", new ObjectMapper.TypeParser());
        mappers.put("completion", new CompletionFieldMapper.TypeParser());
        mappers.put("alias", new FieldAliasMapper.TypeParser());
        mappers.put("geo_point", new GeoPointFieldMapper.TypeParser());
        mappers.put("geo_shape", new BaseGeoShapeFieldMapper.TypeParser());
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry<String, Mapper.TypeParser> entry : mapperPlugin.getMappers().entrySet()) {
                if (mappers.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Mapper [" + entry.getKey() + "] is already registered");
            }
        }
        return Collections.unmodifiableMap(mappers);
    }

    private static Map<String, MetadataFieldMapper.TypeParser> initBuiltInMetadataMappers() {
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> builtInMetadataMappers = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>();
        builtInMetadataMappers.put("_ignored", new IgnoredFieldMapper.TypeParser());
        builtInMetadataMappers.put("_id", new IdFieldMapper.TypeParser());
        builtInMetadataMappers.put("_routing", new RoutingFieldMapper.TypeParser());
        builtInMetadataMappers.put("_index", new IndexFieldMapper.TypeParser());
        builtInMetadataMappers.put("_source", new SourceFieldMapper.TypeParser());
        builtInMetadataMappers.put("_type", new TypeFieldMapper.TypeParser());
        builtInMetadataMappers.put("_version", new VersionFieldMapper.TypeParser());
        builtInMetadataMappers.put("_seq_no", new SeqNoFieldMapper.TypeParser());
        builtInMetadataMappers.put("_field_names", new FieldNamesFieldMapper.TypeParser());
        return Collections.unmodifiableMap(builtInMetadataMappers);
    }

    private static Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers(List<MapperPlugin> mapperPlugins) {
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> metadataMappers = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>();
        int i = 0;
        Map.Entry<String, MetadataFieldMapper.TypeParser> fieldNamesEntry = null;
        for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : builtInMetadataMappers.entrySet()) {
            if (i < builtInMetadataMappers.size() - 1) {
                metadataMappers.put(entry.getKey(), entry.getValue());
            } else {
                assert (entry.getKey().equals("_field_names")) : "_field_names must be the last registered mapper, order counts";
                fieldNamesEntry = entry;
            }
            ++i;
        }
        assert (fieldNamesEntry != null);
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : mapperPlugin.getMetadataMappers().entrySet()) {
                if (entry.getKey().equals("_field_names")) {
                    throw new IllegalArgumentException("Plugin cannot contain metadata mapper [_field_names]");
                }
                if (metadataMappers.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("MetadataFieldMapper [" + entry.getKey() + "] is already registered");
            }
        }
        metadataMappers.put((String)fieldNamesEntry.getKey(), fieldNamesEntry.getValue());
        return Collections.unmodifiableMap(metadataMappers);
    }

    public static Set<String> getBuiltInMetaDataFields() {
        return builtInMetadataMappers.keySet();
    }

    private static Function<String, Predicate<String>> getFieldFilter(List<MapperPlugin> mapperPlugins) {
        Function<String, Predicate<String>> fieldFilter = MapperPlugin.NOOP_FIELD_FILTER;
        for (MapperPlugin mapperPlugin : mapperPlugins) {
            fieldFilter = IndicesModule.and(fieldFilter, mapperPlugin.getFieldFilter());
        }
        return fieldFilter;
    }

    private static Function<String, Predicate<String>> and(Function<String, Predicate<String>> first, Function<String, Predicate<String>> second) {
        if (first == MapperPlugin.NOOP_FIELD_FILTER) {
            return second;
        }
        if (second == MapperPlugin.NOOP_FIELD_FILTER) {
            return first;
        }
        return index -> {
            Predicate firstPredicate = (Predicate)first.apply((String)index);
            Predicate secondPredicate = (Predicate)second.apply((String)index);
            if (firstPredicate == MapperPlugin.NOOP_FIELD_PREDICATE) {
                return secondPredicate;
            }
            if (secondPredicate == MapperPlugin.NOOP_FIELD_PREDICATE) {
                return firstPredicate;
            }
            return firstPredicate.and(secondPredicate);
        };
    }

    @Override
    protected void configure() {
        this.bind(IndicesStore.class).asEagerSingleton();
        this.bind(IndicesClusterStateService.class).asEagerSingleton();
        this.bind(SyncedFlushService.class).asEagerSingleton();
        this.bind(TransportNodesListShardStoreMetaData.class).asEagerSingleton();
        this.bind(GlobalCheckpointSyncAction.class).asEagerSingleton();
        this.bind(TransportResyncReplicationAction.class).asEagerSingleton();
        this.bind(PrimaryReplicaSyncer.class).asEagerSingleton();
    }

    public MapperRegistry getMapperRegistry() {
        return this.mapperRegistry;
    }

    public Collection<Function<IndexSettings, Optional<EngineFactory>>> getEngineFactories() {
        return Collections.emptyList();
    }
}

