/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ArrayValueMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;

public class DenseVectorFieldMapper
extends FieldMapper
implements ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "dense_vector";
    public static short MAX_DIMS_COUNT = (short)500;
    private static final byte INT_BYTES = 4;

    private DenseVectorFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.indexOptions() == IndexOptions.NONE);
    }

    protected DenseVectorFieldMapper clone() {
        return (DenseVectorFieldMapper)super.clone();
    }

    public DenseVectorFieldType fieldType() {
        return (DenseVectorFieldType)super.fieldType();
    }

    public void parse(ParseContext context) throws IOException {
        if (context.externalValueSet()) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] can't be used in multi-fields");
        }
        byte[] buf = new byte[]{};
        int offset = 0;
        short dim = 0;
        XContentParser.Token token = context.parser().nextToken();
        while (token != XContentParser.Token.END_ARRAY) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, () -> ((XContentParser)context.parser()).getTokenLocation());
            float value = context.parser().floatValue(true);
            if (buf.length < offset + 4) {
                buf = ArrayUtil.grow((byte[])buf, (int)(offset + 4));
            }
            int intValue = Float.floatToIntBits(value);
            buf[offset] = (byte)(intValue >> 24);
            buf[offset + 1] = (byte)(intValue >> 16);
            buf[offset + 2] = (byte)(intValue >> 8);
            buf[offset + 3] = (byte)intValue;
            offset += 4;
            if (dim++ >= MAX_DIMS_COUNT) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] has exceeded the maximum allowed number of dimensions of [" + MAX_DIMS_COUNT + "]");
            }
            token = context.parser().nextToken();
        }
        BinaryDocValuesField field = new BinaryDocValuesField(this.fieldType().name(), new BytesRef(buf, 0, offset));
        if (context.doc().getByKey((Object)this.fieldType().name()) != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't not support indexing multiple values for the same field in the same document");
        }
        context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)field);
    }

    protected void parseCreateField(ParseContext context, List<IndexableField> fields) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class DenseVectorFieldType
    extends MappedFieldType {
        public DenseVectorFieldType() {
        }

        protected DenseVectorFieldType(DenseVectorFieldType ref) {
            super((MappedFieldType)ref);
        }

        public DenseVectorFieldType clone() {
            return new DenseVectorFieldType(this);
        }

        public String typeName() {
            return DenseVectorFieldMapper.CONTENT_TYPE;
        }

        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            throw new UnsupportedOperationException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support docvalue_fields or aggregations");
        }

        public Query existsQuery(QueryShardContext context) {
            return new DocValuesFieldExistsQuery(this.name());
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            throw new UnsupportedOperationException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support sorting, scripting or aggregating");
        }

        public Query termQuery(Object value, QueryShardContext context) {
            throw new UnsupportedOperationException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support queries");
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, DenseVectorFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public DenseVectorFieldType fieldType() {
            return (DenseVectorFieldType)super.fieldType();
        }

        public DenseVectorFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new DenseVectorFieldMapper(this.name, this.fieldType, this.defaultFieldType, context.indexSettings(), this.multiFieldsBuilder.build((FieldMapper.Builder)this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new DenseVectorFieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.NONE);
            FIELD_TYPE.setHasDocValues(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

