/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.RenameComponentAction;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.RenameResourceAction;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.SelectionDispatchAction;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RefactoringWizardMessages;

public class RenameAction
extends SelectionDispatchAction {
    private SelectionDispatchAction renameComponentAction;
    private SelectionDispatchAction renameResourceAction;

    public RenameAction(ISelection selection) {
        super(selection);
        this.setText(RefactoringWizardMessages.RenameAction_text);
        this.renameResourceAction = new RenameResourceAction(selection);
        this.renameResourceAction.setText(this.getText());
    }

    public RenameAction(ISelection selection, Object model) {
        super(selection);
        this.setText(RefactoringWizardMessages.RenameAction_text);
        this.renameComponentAction = new RenameComponentAction(selection, model);
        this.renameComponentAction.setText(this.getText());
        this.renameResourceAction = new RenameResourceAction(selection);
        this.renameResourceAction.setText(this.getText());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.renameComponentAction.selectionChanged(event);
        if (this.renameResourceAction != null) {
            this.renameResourceAction.selectionChanged(event);
        }
        this.setEnabled(this.computeEnabledState());
    }

    public void update(ISelection selection) {
        if (this.renameComponentAction != null) {
            this.renameComponentAction.update(selection);
        }
        if (this.renameResourceAction != null) {
            this.renameResourceAction.update(selection);
        }
        this.setEnabled(this.computeEnabledState());
    }

    private boolean computeEnabledState() {
        if (this.renameResourceAction != null) {
            return this.renameComponentAction.isEnabled() || this.renameResourceAction.isEnabled();
        }
        return this.renameComponentAction.isEnabled();
    }

    public void run(IStructuredSelection selection) {
        if (this.renameComponentAction != null && this.renameComponentAction.isEnabled()) {
            this.renameComponentAction.run(selection);
        }
        if (this.renameResourceAction != null && this.renameResourceAction.isEnabled()) {
            this.renameResourceAction.run(selection);
        }
    }

    public void run(ITextSelection selection) {
        if (this.renameComponentAction != null && this.renameComponentAction.canRun()) {
            this.renameComponentAction.run(selection);
        } else {
            MessageDialog.openInformation((Shell)XSDEditorPlugin.getShell(), (String)RefactoringWizardMessages.RenameAction_rename, (String)RefactoringWizardMessages.RenameAction_unavailable);
        }
    }

    public void run(ISelection selection) {
        if (selection == null) {
            super.run();
        } else {
            super.run(selection);
        }
    }

    public final void setRenameComponentAction(SelectionDispatchAction renameComponentAction) {
        this.renameComponentAction = renameComponentAction;
    }
}

