/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;

public class BP2417
extends AssertionProcessVisitor {
    private final WSDLValidatorImpl validator;
    private ErrorList errorList = new ErrorList();
    private static final String NS_LIST_KEY = "namespaces";

    public BP2417(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    private void checkNamespace(QName qname, WSDLTraversalContext ctx) {
        List namespaceList;
        String namespace;
        if (qname != null && (namespace = qname.getNamespaceURI()) != null && (namespaceList = (List)ctx.getParameter(NS_LIST_KEY)) != null && !namespaceList.contains(namespace)) {
            this.errorList.add(qname);
        }
    }

    public void visit(Message message, Object parent, WSDLTraversalContext ctx) {
        if (message != null) {
            Map parts = message.getParts();
            Iterator iter = parts.values().iterator();
            while (iter.hasNext()) {
                Part part = (Part)iter.next();
                this.checkNamespace(part.getElementName(), ctx);
                this.checkNamespace(part.getTypeName(), ctx);
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
        Vector<String> tnsList = null;
        try {
            tnsList = this.validator.getSchemaNamespaceList(definition);
            if (tnsList == null) {
                tnsList = new Vector();
            }
        }
        catch (WSIException wSIException) {
            tnsList = new Vector<String>();
        }
        tnsList.add("http://www.w3.org/2001/XMLSchema");
        HashMap<String, Vector<String>> params = new HashMap<String, Vector<String>>();
        params.put(NS_LIST_KEY, tnsList);
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitMessage(true);
        traversal.ignoreImport();
        traversal.ignoreReferences();
        traversal.traverse(definition, params);
        if (this.errorList.isEmpty()) {
            this.result = "passed";
        } else {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errorList.toString(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

