/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmStateTransition;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenFsmSimpleState
extends DataDrivenFsmState {
    private final List<DataDrivenFsmStateTransition> fTransitions;
    private final DataDrivenAction fOnEntry;
    private final DataDrivenAction fOnExit;

    public static final DataDrivenFsmSimpleState createFinalState(String id) {
        return new DataDrivenFsmSimpleState(id, Collections.emptyList(), DataDrivenAction.NO_ACTION, DataDrivenAction.NO_ACTION);
    }

    public DataDrivenFsmSimpleState(String id, List<DataDrivenFsmStateTransition> transitions, DataDrivenAction onEntry, DataDrivenAction onExit) {
        super(id);
        this.fTransitions = transitions;
        this.fOnEntry = onEntry;
        this.fOnExit = onExit;
    }

    @Override
    public @Nullable DataDrivenFsmState takeTransition(ITmfEvent event, TmfXmlScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        for (DataDrivenFsmStateTransition transition : this.fTransitions) {
            if (!transition.canTake(event, scenarioInfo, container)) continue;
            this.fOnExit.eventHandle(event, scenarioInfo, container);
            String nextStateName = transition.take(event, scenarioInfo, container);
            DataDrivenFsmSimpleState nextState = scenarioInfo.getFsm().getState(nextStateName);
            nextState.fOnEntry.eventHandle(event, scenarioInfo, container);
            return nextState;
        }
        return null;
    }

    @Override
    public boolean isFinal() {
        return this.fTransitions.isEmpty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fTransitions, this.fOnEntry, this.fOnExit);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof DataDrivenFsmSimpleState)) {
            return false;
        }
        DataDrivenFsmSimpleState other = (DataDrivenFsmSimpleState)obj;
        return super.equals(obj) && Objects.equals(this.fTransitions, other.fTransitions) && Objects.equals(this.fOnEntry, other.fOnEntry) && Objects.equals(this.fOnExit, other.fOnExit);
    }

    public String toString() {
        return "State" + this.getId() + ':' + this.fTransitions + ' ' + this.fOnEntry + ' ' + this.fOnExit;
    }
}

