/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.internal.rpm.core.utils.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class DownloadJob
extends Job {
    private IFile file;
    private URLConnection content;
    private static final int MULTIPLIER = 5;
    private static final int KB = 1024;

    public DownloadJob(IFile file, URLConnection content) {
        super(NLS.bind((String)Messages.DownloadJob_0, (Object)file.getName()));
        this.file = file;
        this.content = content;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(NLS.bind((String)Messages.DownloadJob_0, (Object)this.file.getName()), this.content.getContentLength());
        try {
            boolean canceled;
            File tempFile;
            block20: {
                tempFile = File.createTempFile(this.file.getName(), "");
                canceled = false;
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    FileOutputStream fos = new FileOutputStream(tempFile);
                    try {
                        try (BufferedInputStream is = new BufferedInputStream(this.content.getInputStream());){
                            int b;
                            byte[] buf = new byte[5120];
                            while ((b = ((InputStream)is).read(buf)) != -1) {
                                if (monitor.isCanceled()) {
                                    canceled = true;
                                    break;
                                }
                                fos.write(buf, 0, b);
                                monitor.worked(1);
                            }
                        }
                        if (fos == null) break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            if (!canceled) {
                if (this.file.exists()) {
                    this.file.setContents((InputStream)new FileInputStream(tempFile), true, false, monitor);
                } else {
                    this.file.create((InputStream)new FileInputStream(tempFile), true, monitor);
                }
            }
            tempFile.delete();
        }
        catch (IOException | CoreException e) {
            Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.linuxtools.rpm.core")).log((IStatus)new Status(4, "org.eclipse.linuxtools.rpm.core", e.getMessage(), e));
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

