/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.TreeExpandCollapseAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.BrowserView;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class BrowserViewAction
extends Action
implements ISelectionListener,
IDoubleClickListener {
    private final IWorkbenchWindow window;
    private final BrowserView viewer;
    private IStructuredSelection selection;
    private TreeExpandCollapseAction expandAction;

    public BrowserViewAction(IWorkbenchWindow window, BrowserView browser) {
        this.window = window;
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.viewer = browser;
        this.expandAction = new TreeExpandCollapseAction(this.viewer);
    }

    public void dispose() {
        this.window.getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.selection = null;
        this.expandAction.dispose();
        this.expandAction = null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection incoming) {
        if (incoming instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)incoming;
            this.setEnabled(this.selection.size() == 1);
        } else {
            this.setEnabled(false);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        this.run();
    }

    protected Object getSelectedElement() {
        return ((IStructuredSelection)this.viewer.getViewer().getSelection()).getFirstElement();
    }

    protected void runExpandAction() {
        this.expandAction.run();
    }
}

