/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.FileInfoExtractor;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.SftpEventListenerManager;

public interface SftpFileSystemAccessor {
    public static final List<String> DEFAULT_UNIX_VIEW = Collections.singletonList("unix:*");
    public static final Map<String, FileInfoExtractor<?>> FILEATTRS_RESOLVERS = GenericUtils.mapBuilder((Comparator)String.CASE_INSENSITIVE_ORDER).put((Object)"isRegularFile", (Object)FileInfoExtractor.ISREG).put((Object)"isDirectory", (Object)FileInfoExtractor.ISDIR).put((Object)"isSymbolicLink", (Object)FileInfoExtractor.ISSYMLINK).put((Object)"permissions", (Object)FileInfoExtractor.PERMISSIONS).put((Object)"size", (Object)FileInfoExtractor.SIZE).put((Object)"lastModifiedTime", (Object)FileInfoExtractor.LASTMODIFIED).immutable();
    public static final SftpFileSystemAccessor DEFAULT = new SftpFileSystemAccessor(){

        public String toString() {
            return SftpFileSystemAccessor.class.getSimpleName() + "[DEFAULT]";
        }
    };

    default public SeekableByteChannel openFile(ServerSession session, SftpEventListenerManager subsystem, Path file, String handle, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return FileChannel.open(file, options, attrs);
    }

    default public FileLock tryLock(ServerSession session, SftpEventListenerManager subsystem, Path file, String handle, Channel channel, long position, long size, boolean shared) throws IOException {
        if (!(channel instanceof FileChannel)) {
            throw new StreamCorruptedException("Non file channel to lock: " + channel);
        }
        return ((FileChannel)channel).lock(position, size, shared);
    }

    default public void syncFileData(ServerSession session, SftpEventListenerManager subsystem, Path file, String handle, Channel channel) throws IOException {
        if (!(channel instanceof FileChannel)) {
            throw new StreamCorruptedException("Non file channel to sync: " + channel);
        }
        ((FileChannel)channel).force(true);
    }

    default public DirectoryStream<Path> openDirectory(ServerSession session, SftpEventListenerManager subsystem, Path dir, String handle) throws IOException {
        return Files.newDirectoryStream(dir);
    }
}

