/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Image;
import org.jkiss.dbeaver.ext.erd.editor.ERDViewStyle;
import org.jkiss.dbeaver.ext.erd.figures.AttributeItemFigure;
import org.jkiss.dbeaver.ext.erd.figures.AttributeListFigure;
import org.jkiss.dbeaver.ext.erd.figures.EditableLabel;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class EntityFigure
extends Figure {
    private final EntityPart part;
    private AttributeListFigure keyFigure;
    private AttributeListFigure attributeFigure;
    private EditableLabel nameLabel;

    public EntityFigure(EntityPart part) {
        String entityName;
        this.part = part;
        ERDEntity entity = part.getEntity();
        boolean useFQN = part.getDiagram().hasAttributeStyle(ERDViewStyle.ENTITY_FQN);
        boolean showComments = part.getDiagram().hasAttributeStyle(ERDViewStyle.COMMENTS);
        Image tableImage = DBeaverIcons.getImage((DBPImage)((DBSEntity)entity.getObject()).getEntityType().getIcon());
        this.keyFigure = new AttributeListFigure(entity, true);
        this.attributeFigure = new AttributeListFigure(entity, false);
        String string = entityName = useFQN ? DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)entity.getObject()), (DBPEvaluationContext)DBPEvaluationContext.DDL) : ((DBSEntity)entity.getObject()).getName();
        if (!CommonUtils.isEmpty((String)entity.getAlias())) {
            entityName = String.valueOf(entityName) + " " + entity.getAlias();
        }
        this.nameLabel = new EditableLabel(entityName);
        if (tableImage != null) {
            this.nameLabel.setIcon(tableImage);
        }
        this.nameLabel.setBorder((Border)new MarginBorder(3));
        Label descLabel = null;
        if (showComments && !CommonUtils.isEmpty((String)((DBSEntity)entity.getObject()).getDescription())) {
            descLabel = new Label(((DBSEntity)entity.getObject()).getDescription());
        }
        ToolbarLayout layout = new ToolbarLayout();
        layout.setHorizontal(false);
        layout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)layout);
        LineBorder border = new LineBorder(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.lines.foreground"), 2);
        this.setBorder((Border)border);
        this.setOpaque(true);
        this.add((IFigure)this.nameLabel);
        if (descLabel != null) {
            this.add((IFigure)descLabel);
        }
        this.add((IFigure)this.keyFigure);
        this.add((IFigure)this.attributeFigure);
        this.refreshColors();
    }

    public void refreshColors() {
        ColorRegistry colorRegistry = UIUtils.getColorRegistry();
        if (this.part.getEntity().isPrimary()) {
            this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.primary.background"));
        } else if (((DBSEntity)this.part.getEntity().getObject()).getEntityType() == DBSEntityType.ASSOCIATION) {
            this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.association.background"));
        } else {
            this.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.regular.background"));
        }
        this.setForegroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.name.foreground"));
        this.nameLabel.setForegroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.entity.name.foreground"));
    }

    public void setSelected(boolean isSelected) {
        LineBorder lineBorder = (LineBorder)this.getBorder();
        if (isSelected) {
            lineBorder.setWidth(3);
        } else {
            lineBorder.setWidth(2);
        }
    }

    public EditableLabel getNameLabel() {
        return this.nameLabel;
    }

    public AttributeListFigure getKeyFigure() {
        return this.keyFigure;
    }

    public AttributeListFigure getColumnsFigure() {
        return this.attributeFigure;
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (figure instanceof AttributeItemFigure) {
            ColorRegistry colorRegistry = UIUtils.getColorRegistry();
            figure.setForegroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.attributes.foreground"));
            figure.setBackgroundColor(colorRegistry.get("org.jkiss.dbeaver.erd.diagram.attributes.background"));
            IFigure attrExtra = this.createRightPanel();
            AttributeItemFigure attributeItemFigure = (AttributeItemFigure)figure;
            attributeItemFigure.setRightPanel(attrExtra);
            if (attributeItemFigure.getAttribute().isInPrimaryKey()) {
                this.keyFigure.add(figure, new GridData(32, 2, true, false));
                this.keyFigure.add(attrExtra, new GridData(130));
            } else {
                this.attributeFigure.add(figure, new GridData(32, 2, true, false));
                this.attributeFigure.add(attrExtra, new GridData(130));
            }
        } else {
            super.add(figure, constraint, index);
        }
    }

    protected IFigure createRightPanel() {
        EditableLabel label = new EditableLabel("");
        label.setTextAlignment(4);
        return label;
    }

    public List<AttributeItemFigure> getAttributeFigures() {
        ArrayList<AttributeItemFigure> result = new ArrayList<AttributeItemFigure>();
        result.addAll(this.keyFigure.getAttributes());
        result.addAll(this.attributeFigure.getAttributes());
        return result;
    }
}

