/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.Collections;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndexColumn;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLIndexManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditIndexPage;
import org.jkiss.utils.CommonUtils;

public class SQLServerIndexManager
extends SQLIndexManager<SQLServerTableIndex, SQLServerTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, SQLServerTableIndex> getObjectsCache(SQLServerTableIndex object) {
        return ((SQLServerSchema)((SQLServerTableBase)object.getTable()).getContainer()).getIndexCache();
    }

    protected SQLServerTableIndex createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final SQLServerTableBase parent, Object from) {
        return (SQLServerTableIndex)new UITask<SQLServerTableIndex>(){

            protected SQLServerTableIndex runTask() {
                EditIndexPage editPage = new EditIndexPage("Create index", (DBSTable)parent, Collections.singletonList(DBSIndexType.OTHER));
                if (!editPage.edit()) {
                    return null;
                }
                SQLServerTableIndex index = new SQLServerTableIndex(parent, editPage.isUnique(), false, null, editPage.getIndexType(), editPage.getDescription(), false);
                StringBuilder idxName = new StringBuilder(64);
                idxName.append(CommonUtils.escapeIdentifier((String)parent.getName()));
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    if (colIndex == 1) {
                        idxName.append("_").append(CommonUtils.escapeIdentifier((String)tableColumn.getName()));
                    }
                    index.addColumn(new SQLServerTableIndexColumn(index, 0L, (SQLServerTableColumn)tableColumn, colIndex++, !Boolean.TRUE.equals(editPage.getAttributeProperty(tableColumn, "desc"))));
                }
                idxName.append("_IDX");
                index.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)index, (String)idxName.toString()));
                return index;
            }
        }.execute();
    }
}

