/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.plan;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.plan.PostgresPlanNodeExternal;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerDeSerialInfo;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;
import org.jkiss.dbeaver.model.impl.plan.ExecutionPlanDeserializer;

public class PostgresPlanLoader
extends AbstractExecutionPlan {
    private String query;
    private List<PostgresPlanNodeExternal> rootNodes;

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() throws DBException {
        return "LOADED" + this.query;
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.rootNodes;
    }

    public Object getPlanFeature(String feature) {
        if ("plan.cost".equals(feature) || "plan.duration".equals(feature) || "plan.rows".equals(feature)) {
            return true;
        }
        return super.getPlanFeature(feature);
    }

    public void deserialize(PostgreDataSource dataSource, Reader planData) throws InvocationTargetException {
        try {
            JsonObject jo = new JsonParser().parse(planData).getAsJsonObject();
            this.query = jo.get("sql").getAsString();
            ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
            this.rootNodes = loader.loadRoot((DBPDataSource)dataSource, jo, (DBCQueryPlannerDeSerialInfo)new DBCQueryPlannerDeSerialInfo<PostgresPlanNodeExternal>(){

                public PostgresPlanNodeExternal createNode(DBPDataSource datasource, JsonObject node, PostgresPlanNodeExternal parent) {
                    return new PostgresPlanNodeExternal((PostgreDataSource)datasource, node, parent);
                }
            });
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }
}

