/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewConfiguration;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardManagerDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class DashboardViewConfigDialog
extends BaseDialog {
    private DashboardViewConfiguration viewConfiguration;

    public DashboardViewConfigDialog(Shell shell, DashboardViewConfiguration viewConfiguration) {
        super(shell, "Dashboard [" + viewConfiguration.getDataSourceContainer().getName() + " / " + viewConfiguration.getViewId() + "]", null);
        this.viewConfiguration = viewConfiguration;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Group viewGroup = UIUtils.createControlGroup((Composite)composite, (String)"View configuration", (int)2, (int)768, (int)0);
        Button connectOnActivationCheck = UIUtils.createCheckbox((Composite)viewGroup, (String)"Connect to database on activation", (String)"Open database connection on view activation", (boolean)this.viewConfiguration.isOpenConnectionOnActivate(), (int)2);
        connectOnActivationCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardViewConfigDialog.this.viewConfiguration.setOpenConnectionOnActivate(((Button)e.widget).getSelection());
            }
        });
        Button separateConnectionCheck = UIUtils.createCheckbox((Composite)viewGroup, (String)"Use separate connection", (String)"Open special connection for charts data reading. Otherwise use main datasource connection", (boolean)this.viewConfiguration.isUseSeparateConnection(), (int)2);
        separateConnectionCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardViewConfigDialog.this.viewConfiguration.setUseSeparateConnection(((Button)e.widget).getSelection());
            }
        });
        separateConnectionCheck.setEnabled(false);
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        return contents;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button managerButton = this.createButton(parent, 1, "Manage ...", false);
        ((GridData)managerButton.getLayoutData()).horizontalAlignment = 1;
        ((GridData)managerButton.getLayoutData()).grabExcessHorizontalSpace = true;
        managerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new DashboardManagerDialog(UIUtils.getActiveWorkbenchShell()).open();
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    protected void okPressed() {
        super.okPressed();
        this.viewConfiguration.saveSettings();
    }
}

